! 
! Copyright (c) 2004-2018, NVIDIA CORPORATION.  All rights reserved.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
! 


! directives.h -- contains preprocessor directives for F90 rte files

#define PREFIX(x) f90##x
#define _PREFIX(x) _f90##x

#ifdef DESC_I8
#define DESC_INT INTEGER(8)
#define F90_matmul_cplx16_contmxm	PREFIX(_mm_cplx16_contmxm_i8)
#define F90_matmul_cplx16_contmxv	PREFIX(_mm_cplx16_contmxv_i8)
#define F90_matmul_cplx16_contvxm	PREFIX(_mm_cplx16_contvxm_i8)
#define F90_matmul_cplx16_str1		PREFIX(_mm_cplx16_str1_i8)
#define F90_matmul_cplx16_str1_mxv	PREFIX(_mm_cplx16_str1_mxv_i8)
#define F90_matmul_cplx16_str1_mxv_t	PREFIX(_mm_cplx16_str1_mxv_t_i8)
#define F90_matmul_cplx16_str1_vxm	PREFIX(_mm_cplx16_str1_vxm_i8)
#define F90_matmul_cplx32_contmxm	PREFIX(_mm_cplx32_contmxm_i8)
#define F90_matmul_cplx32_contmxv	PREFIX(_mm_cplx32_contmxv_i8)
#define F90_matmul_cplx32_contvxm	PREFIX(_mm_cplx32_contvxm_i8)
#define F90_matmul_cplx32_str1		PREFIX(_mm_cplx32_str1_i8)
#define F90_matmul_cplx32_str1_mxv	PREFIX(_mm_cplx32_str1_mxv_i8)
#define F90_matmul_cplx8_contmxm	PREFIX(_mm_cplx8_contmxm_i8)
#define F90_matmul_cplx8_contmxv	PREFIX(_mm_cplx8_contmxv_i8)
#define F90_matmul_cplx8_contvxm	PREFIX(_mm_cplx8_contvxm_i8)
#define F90_matmul_cplx8_str1		PREFIX(_mm_cplx8_str1_i8)
#define F90_matmul_cplx8_str1_mxv	PREFIX(_mm_cplx8_str1_mxv_i8)
#define F90_matmul_cplx8_str1_mxv_t	PREFIX(_mm_cplx8_str1_mxv_t_i8)
#define F90_matmul_cplx8_str1_t		PREFIX(_mm_cplx8_str1_t_i8)
#define F90_matmul_cplx8_str1_vxm	PREFIX(_mm_cplx8_str1_vxm_i8)
#define F90_matmul_int1_contmxm		PREFIX(_mm_int1_contmxm_i8)
#define F90_matmul_int1_contmxv		PREFIX(_mm_int1_contmxv_i8)
#define F90_matmul_int1_contvxm		PREFIX(_mm_int1_contvxm_i8)
#define F90_matmul_int1_str1		PREFIX(_mm_int1_str1_i8)
#define F90_matmul_int1_str1_mxv	PREFIX(_mm_int1_str1_mxv_i8)
#define F90_matmul_int1_str1_vxm	PREFIX(_mm_int1_str1_vxm_i8)
#define F90_matmul_int2_contmxm		PREFIX(_mm_int2_contmxm_i8)
#define F90_matmul_int2_contmxv		PREFIX(_mm_int2_contmxv_i8)
#define F90_matmul_int2_contvxm		PREFIX(_mm_int2_contvxm_i8)
#define F90_matmul_int2_str1		PREFIX(_mm_int2_str1_i8)
#define F90_matmul_int2_str1_mxv	PREFIX(_mm_int2_str1_mxv_i8)
#define F90_matmul_int2_str1_vxm	PREFIX(_mm_int2_str1_vxm_i8)
#define F90_matmul_int4_contmxm		PREFIX(_mm_int4_contmxm_i8)
#define F90_matmul_int4_contmxv		PREFIX(_mm_int4_contmxv_i8)
#define F90_matmul_int4_contvxm		PREFIX(_mm_int4_contvxm_i8)
#define F90_matmul_int4_str1		PREFIX(_mm_int4_str1_i8)
#define F90_matmul_int4_str1_mxv	PREFIX(_mm_int4_str1_mxv_i8)
#define F90_matmul_int4_str1_vxm	PREFIX(_mm_int4_str1_vxm_i8)
#define F90_matmul_int8_contmxm		PREFIX(_mm_int8_contmxm_i8)
#define F90_matmul_int8_contmxv		PREFIX(_mm_int8_contmxv_i8)
#define F90_matmul_int8_contvxm		PREFIX(_mm_int8_contvxm_i8)
#define F90_matmul_int8_str1		PREFIX(_mm_int8_str1_i8)
#define F90_matmul_int8_str1_mxv	PREFIX(_mm_int8_str1_mxv_i8)
#define F90_matmul_int8_str1_vxm	PREFIX(_mm_int8_str1_vxm_i8)
#define F90_matmul_log1_contmxm		PREFIX(_mm_log1_contmxm_i8)
#define F90_matmul_log1_contmxv		PREFIX(_mm_log1_contmxv_i8)
#define F90_matmul_log1_contvxm		PREFIX(_mm_log1_contvxm_i8)
#define F90_matmul_log2_contmxm		PREFIX(_mm_log2_contmxm_i8)
#define F90_matmul_log2_contmxv		PREFIX(_mm_log2_contmxv_i8)
#define F90_matmul_log2_contvxm		PREFIX(_mm_log2_contvxm_i8)
#define F90_matmul_log4_contmxm		PREFIX(_mm_log4_contmxm_i8)
#define F90_matmul_log4_contmxv		PREFIX(_mm_log4_contmxv_i8)
#define F90_matmul_log4_contvxm		PREFIX(_mm_log4_contvxm_i8)
#define F90_matmul_log8_contmxm		PREFIX(_mm_log8_contmxm_i8)
#define F90_matmul_log8_contmxv		PREFIX(_mm_log8_contmxv_i8)
#define F90_matmul_log8_contvxm		PREFIX(_mm_log8_contvxm_i8)
#define F90_matmul_real16_contmxm	PREFIX(_mm_real16_contmxm_i8)
#define F90_matmul_real16_contmxv	PREFIX(_mm_real16_contmxv_i8)
#define F90_matmul_real16_contvxm	PREFIX(_mm_real16_contvxm_i8)
#define F90_matmul_real4_contmxm	PREFIX(_mm_real4_contmxm_i8)
#define F90_matmul_real4_contmxv	PREFIX(_mm_real4_contmxv_i8)
#define F90_matmul_real4_contvxm	PREFIX(_mm_real4_contvxm_i8)
#define F90_matmul_real4_str1		PREFIX(_mm_real4_str1_i8)
#define F90_matmul_real4_str1_mxv	PREFIX(_mm_real4_str1_mxv_i8)
#define F90_matmul_real4_str1_mxv_t	PREFIX(_mm_real4_str1_mxv_t_i8)
#define F90_matmul_real4_str1_t		PREFIX(_mm_real4_str1_t_i8)
#define F90_matmul_real4_str1_vxm	PREFIX(_mm_real4_str1_vxm_i8)
#define F90_matmul_real8_contmxm	PREFIX(_mm_real8_contmxm_i8)
#define F90_matmul_real8_contmxv	PREFIX(_mm_real8_contmxv_i8)
#define F90_matmul_real8_contvxm	PREFIX(_mm_real8_contvxm_i8)
#define F90_matmul_real8_str1		PREFIX(_mm_real8_str1_i8)
#define _F90_matmul_real8_str1a		_PREFIX(_mm_real8_str1a_i8)
#define _F90_matmul_real8_str1b		_PREFIX(_mm_real8_str1b_i8)
#define _F90_matmul_real8_str1c		_PREFIX(_mm_real8_str1c_i8)
#define F90_matmul_real8_str1_mxv	PREFIX(_mm_real8_str1_mxv_i8)
#define F90_matmul_real8_str1_mxv_t	PREFIX(_mm_real8_str1_mxv_t_i8)
#define F90_matmul_real8_str1_vxm	PREFIX(_mm_real8_str1_vxm_i8)
#else
#define DESC_INT INTEGER(4)
#define F90_matmul_cplx16_contmxm	PREFIX(_mm_cplx16_contmxm)
#define F90_matmul_cplx16_contmxv	PREFIX(_mm_cplx16_contmxv)
#define F90_matmul_cplx16_contvxm	PREFIX(_mm_cplx16_contvxm)
#define F90_matmul_cplx16_str1		PREFIX(_mm_cplx16_str1)
#define F90_matmul_cplx16_str1_mxv	PREFIX(_mm_cplx16_str1_mxv)
#define F90_matmul_cplx16_str1_mxv_t	PREFIX(_mm_cplx16_str1_mxv_t)
#define F90_matmul_cplx16_str1_vxm	PREFIX(_mm_cplx16_str1_vxm)
#define F90_matmul_cplx32_contmxm	PREFIX(_mm_cplx32_contmxm)
#define F90_matmul_cplx32_contmxv	PREFIX(_mm_cplx32_contmxv)
#define F90_matmul_cplx32_contvxm	PREFIX(_mm_cplx32_contvxm)
#define F90_matmul_cplx32_str1		PREFIX(_mm_cplx32_str1)
#define F90_matmul_cplx32_str1_mxv	PREFIX(_mm_cplx32_str1_mxv)
#define F90_matmul_cplx8_contmxm	PREFIX(_mm_cplx8_contmxm)
#define F90_matmul_cplx8_contmxv	PREFIX(_mm_cplx8_contmxv)
#define F90_matmul_cplx8_contvxm	PREFIX(_mm_cplx8_contvxm)
#define F90_matmul_cplx8_str1		PREFIX(_mm_cplx8_str1)
#define F90_matmul_cplx8_str1_mxv	PREFIX(_mm_cplx8_str1_mxv)
#define F90_matmul_cplx8_str1_mxv_t	PREFIX(_mm_cplx8_str1_mxv_t)
#define F90_matmul_cplx8_str1_t		PREFIX(_mm_cplx8_str1_t)
#define F90_matmul_cplx8_str1_vxm	PREFIX(_mm_cplx8_str1_vxm)
#define F90_matmul_int1_contmxm		PREFIX(_mm_int1_contmxm)
#define F90_matmul_int1_contmxv		PREFIX(_mm_int1_contmxv)
#define F90_matmul_int1_contvxm		PREFIX(_mm_int1_contvxm)
#define F90_matmul_int1_str1		PREFIX(_mm_int1_str1)
#define F90_matmul_int1_str1_mxv	PREFIX(_mm_int1_str1_mxv)
#define F90_matmul_int1_str1_vxm	PREFIX(_mm_int1_str1_vxm)
#define F90_matmul_int2_contmxm		PREFIX(_mm_int2_contmxm)
#define F90_matmul_int2_contmxv		PREFIX(_mm_int2_contmxv)
#define F90_matmul_int2_contvxm		PREFIX(_mm_int2_contvxm)
#define F90_matmul_int2_str1		PREFIX(_mm_int2_str1)
#define F90_matmul_int2_str1_mxv	PREFIX(_mm_int2_str1_mxv)
#define F90_matmul_int2_str1_vxm	PREFIX(_mm_int2_str1_vxm)
#define F90_matmul_int4_contmxm		PREFIX(_mm_int4_contmxm)
#define F90_matmul_int4_contmxv		PREFIX(_mm_int4_contmxv)
#define F90_matmul_int4_contvxm		PREFIX(_mm_int4_contvxm)
#define F90_matmul_int4_str1		PREFIX(_mm_int4_str1)
#define F90_matmul_int4_str1_mxv	PREFIX(_mm_int4_str1_mxv)
#define F90_matmul_int4_str1_vxm	PREFIX(_mm_int4_str1_vxm)
#define F90_matmul_int8_contmxm		PREFIX(_mm_int8_contmxm)
#define F90_matmul_int8_contmxv		PREFIX(_mm_int8_contmxv)
#define F90_matmul_int8_contvxm		PREFIX(_mm_int8_contvxm)
#define F90_matmul_int8_str1		PREFIX(_mm_int8_str1)
#define F90_matmul_int8_str1_mxv	PREFIX(_mm_int8_str1_mxv)
#define F90_matmul_int8_str1_vxm	PREFIX(_mm_int8_str1_vxm)
#define F90_matmul_log1_contmxm		PREFIX(_mm_log1_contmxm)
#define F90_matmul_log1_contmxv		PREFIX(_mm_log1_contmxv)
#define F90_matmul_log1_contvxm		PREFIX(_mm_log1_contvxm)
#define F90_matmul_log2_contmxm		PREFIX(_mm_log2_contmxm)
#define F90_matmul_log2_contmxv		PREFIX(_mm_log2_contmxv)
#define F90_matmul_log2_contvxm		PREFIX(_mm_log2_contvxm)
#define F90_matmul_log4_contmxm		PREFIX(_mm_log4_contmxm)
#define F90_matmul_log4_contmxv		PREFIX(_mm_log4_contmxv)
#define F90_matmul_log4_contvxm		PREFIX(_mm_log4_contvxm)
#define F90_matmul_log8_contmxm		PREFIX(_mm_log8_contmxm)
#define F90_matmul_log8_contmxv		PREFIX(_mm_log8_contmxv)
#define F90_matmul_log8_contvxm		PREFIX(_mm_log8_contvxm)
#define F90_matmul_real16_contmxm	PREFIX(_mm_real16_contmxm)
#define F90_matmul_real16_contmxv	PREFIX(_mm_real16_contmxv)
#define F90_matmul_real16_contvxm	PREFIX(_mm_real16_contvxm)
#define F90_matmul_real4_contmxm	PREFIX(_mm_real4_contmxm)
#define F90_matmul_real4_contmxv	PREFIX(_mm_real4_contmxv)
#define F90_matmul_real4_contvxm	PREFIX(_mm_real4_contvxm)
#define F90_matmul_real4_str1		PREFIX(_mm_real4_str1)
#define F90_matmul_real4_str1_mxv	PREFIX(_mm_real4_str1_mxv)
#define F90_matmul_real4_str1_mxv_t	PREFIX(_mm_real4_str1_mxv_t)
#define F90_matmul_real4_str1_t		PREFIX(_mm_real4_str1_t)
#define F90_matmul_real4_str1_vxm	PREFIX(_mm_real4_str1_vxm)
#define F90_matmul_real8_contmxm	PREFIX(_mm_real8_contmxm)
#define F90_matmul_real8_contmxv	PREFIX(_mm_real8_contmxv)
#define F90_matmul_real8_contvxm	PREFIX(_mm_real8_contvxm)
#define F90_matmul_real8_str1		PREFIX(_mm_real8_str1)
#define _F90_matmul_real8_str1a		_PREFIX(_mm_real8_str1a)
#define _F90_matmul_real8_str1b		_PREFIX(_mm_real8_str1b)
#define _F90_matmul_real8_str1c		_PREFIX(_mm_real8_str1c)
#define F90_matmul_real8_str1_mxv	PREFIX(_mm_real8_str1_mxv)
#define F90_matmul_real8_str1_mxv_t	PREFIX(_mm_real8_str1_mxv_t)
#define F90_matmul_real8_str1_vxm	PREFIX(_mm_real8_str1_vxm)
#endif /* DESC_I8 */
