	SUBROUTINE UNPROTECT_CMND_DATA

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* unprotect (flag as not in use) the data from the most recent command

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program

* V230: 7/27/92 - removed code from GET_CMND_DATA
*       *acm* 3/12 6D Ferret (common uses nferdims in tmap_dims.parm)
* V740: 1/18 *acm* for issue 1854, protection status temporarily reset 
*             for curvi-coord plot with /SET

        IMPLICIT NONE
	include 'tmap_dims.parm'
	include	'ferret.parm'
	include 'xvariables.cmn'

* calling argument declarations
* ...

* local variable declarations
	INTEGER		nu, mr

* remove protections from the data grids
	DO 400 nu = 1, num_uvars_in_cmnd
	   mr = is_mr( nu )
	   IF ( mr_protected(mr) .NE. mr_deleted ) 
     .                                CALL MR_NOT_IN_USE( mr )
 400	CONTINUE

! temp diagnostic - last mem var fetched should never be in-use by this stage
 	IF ( mr_protected( mr ) .NE. mr_perm_protected
     . .AND. mr_protected( mr ) .NE. mr_not_protected
     . .AND. mr_protected( mr ) .NE. mr_temporary
     . .AND. mr_protected( mr ) .NE. mr_deleted
     . .AND. mr_protected( mr ) .GT. mr_keep_flag )
     .			WRITE (6,*) 'get_cmnd_prot_err'

 	RETURN
	END
