/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef INSPECTOR_TEST_EQ
#define INSPECTOR_TEST_EQ_(T0_, T1_) inspector_test_eq_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_EQ(x, y) INSPECTOR_TEST_EQ_(x, y)

#define INSPECTOR_TEST_NEQ_(T0_, T1_) inspector_test_ne_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_NEQ(x, y) INSPECTOR_TEST_NEQ_(x, y)

#define INSPECTOR_TEST_LT_(T0_, T1_) inspector_test_lt_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_LT(x, y) INSPECTOR_TEST_LT_(x, y)

#define INSPECTOR_TEST_GT_(T0_, T1_) inspector_test_gt_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_GT(x, y) INSPECTOR_TEST_GT_(x, y)

#define INSPECTOR_TEST_LE_(T0_, T1_) inspector_test_le_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_LE(x, y) INSPECTOR_TEST_LE_(x, y)

#define INSPECTOR_TEST_GE_(T0_, T1_) inspector_test_ge_ ## T0_ ## _ ## T1_
#define INSPECTOR_TEST_GE(x, y) INSPECTOR_TEST_GE_(x, y)

#define INSPECTOR_TEST_ZERO_(T0_, T1_) inspector_test_zero_ ## T0_
#define INSPECTOR_TEST_ZERO(x, y) INSPECTOR_TEST_ZERO_(x, y)

#define INSPECTOR_TEST_ONE_(T0_, T1_) inspector_test_one_ ## T0_
#define INSPECTOR_TEST_ONE(x, y) INSPECTOR_TEST_ONE_(x, y)
#endif

static int
INSPECTOR_TEST_EQ(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a == b;
}

static int
INSPECTOR_TEST_NEQ(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a != b;
}

static int
INSPECTOR_TEST_LT(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a < b;
}

static int
INSPECTOR_TEST_GT(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a > b;
}

static int
INSPECTOR_TEST_LE(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a <= b;
}

static int
INSPECTOR_TEST_GE(TYPE0, TYPE1)(void *a_ptr, void *b_ptr)
{
	TYPE0 a = *(TYPE0*)a_ptr;
	TYPE1 b = *(TYPE1*)b_ptr;
	return a >= b;
}

#if 0
static int
INSPECTOR_TEST_ZERO(TYPE0, TYPE1)(TYPE0 *a_ptr, TYPE1 *b_ptr)
{
	TYPE0 a = *a_ptr;
	return a == 0;
}

static int
INSPECTOR_TEST_ONE(TYPE0, TYPE1)(TYPE0 *a_ptr, TYPE1 *b_ptr)
{
	TYPE0 a = *a_ptr;
	return a == 1;
}
#endif

#undef TYPE0
#undef TYPE1
