/*
 * Copyright (C) 2007-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG_IO	0
#define DEBUG_IO_START	0
#define DEBUG_IO_END	(DEBUG_MEM_START + 0xffffffff)

#ifdef STATE

struct {

} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(uiorb)(struct cpssp *cpssp, paddr_t addr, uint8_t *valp);
/*forward*/ static void
NAME_(uiorw)(struct cpssp *cpssp, paddr_t addr, uint16_t *valp);
/*forward*/ static void
NAME_(uiord)(struct cpssp *cpssp, paddr_t addr, uint32_t *valp);
/*forward*/ static void
NAME_(uiowb)(struct cpssp *cpssp, paddr_t addr, uint8_t value);
/*forward*/ static void
NAME_(uioww)(struct cpssp *cpssp, paddr_t addr, uint16_t value);
/*forward*/ static void
NAME_(uiowd)(struct cpssp *cpssp, paddr_t addr, uint32_t value);

/*forward*/ static void
NAME_(reset)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(uior)(struct cpssp *cpssp, paddr_t port, int size, udata_t *valp)
{
	const int B = sizeof(udata_t);
	udata_t val;
	unsigned int bs;
	unsigned int offset;
	unsigned int count;
	udata_t tmp;

	val = 0;
	count = 0;

	offset = port & (B - 1);
	bs = ((1 << size) - 1) << (port & (B - 1));
	port &= ~(B - 1);

	while (bs) {
		NAME_(bus_ior)(cpssp, port, bs & ((1 << B) - 1), &tmp);
		tmp >>= (8 * offset);
		val |= tmp << (8 * count);
		count += B - offset;

		offset = 0;
		bs >>= B;
		port += B;
	}

	*valp = val;
}

static void
NAME_(uiorb)(struct cpssp *cpssp, paddr_t port, uint8_t *valp)
{
	udata_t val;

	NAME_(uior)(cpssp, port, sizeof(*valp), &val);

	*valp = (uint8_t) val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx -> 0x%02x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, *valp);
	}
#endif
}

static void
NAME_(uiorw)(struct cpssp *cpssp, paddr_t port, uint16_t *valp)
{
	udata_t val;

	NAME_(uior)(cpssp, port, sizeof(*valp), &val);

	*valp = (uint16_t) val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx -> 0x%04x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, *valp);
	}
#endif
}

static void
NAME_(uiord)(struct cpssp *cpssp, paddr_t port, uint32_t *valp)
{
	udata_t val;

	NAME_(uior)(cpssp, port, sizeof(*valp), &val);

	*valp = (uint32_t) val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx -> 0x%08x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, *valp);
	}
#endif
}

static void
NAME_(uiow)(struct cpssp *cpssp, paddr_t port, int size, udata_t val)
{
	const int B = sizeof(udata_t);
	unsigned int bs;
	unsigned int offset;
	unsigned int count;
	udata_t tmp;

	count = 0;

	offset = port & (B - 1);
	bs = ((1 << size) - 1) << (port & (B - 1));
	port &= ~(B - 1);

	while (bs) {
		tmp = val >> (8 * count);
		tmp <<= (8 * offset);
		NAME_(bus_iow)(cpssp, port, bs & ((1 << B) - 1), tmp);
		count += B - offset;

		offset = 0;
		bs >>= B;
		port += B;
	}
}

static void
NAME_(uiowb)(struct cpssp *cpssp, paddr_t port, uint8_t value)
{
	udata_t val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx <- 0x%02x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, value);
	}
#endif

	val = (udata_t) value;

	NAME_(uiow)(cpssp, port, sizeof(value), val);
}

static void
NAME_(uioww)(struct cpssp *cpssp, paddr_t port, uint16_t value)
{
	udata_t val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx <- 0x%04x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, value);
	}
#endif

	val = (udata_t) value;

	NAME_(uiow)(cpssp, port, sizeof(value), val);
}

static void
NAME_(uiowd)(struct cpssp *cpssp, paddr_t port, uint32_t value)
{
	udata_t val;

#if DEBUG_IO
	if (2 <= DEBUG_IO + loglevel
	 && DEBUG_IO_START <= port && port < DEBUG_IO_END) {
		fprintf(stderr, "%s: %llu: 0x%08lx <- 0x%08x\n", __FUNCTION__,
				cpssp->process.inst_cnt, port, value);
	}
#endif

	val = (udata_t) value;

	NAME_(uiow)(cpssp, port, sizeof(value), val);
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG_IO
#undef DEBUG_IO_START
#undef DEBUG_IO_END
