// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHOOSER_CONTROLLER_MOCK_CHOOSER_CONTROLLER_VIEW_H_
#define CHROME_BROWSER_CHOOSER_CONTROLLER_MOCK_CHOOSER_CONTROLLER_VIEW_H_

#include "chrome/browser/chooser_controller/chooser_controller.h"

#include "testing/gmock/include/gmock/gmock.h"

class MockChooserControllerView : public ChooserController::View {
 public:
  MockChooserControllerView();
  MockChooserControllerView(MockChooserControllerView&) = delete;
  MockChooserControllerView& operator=(MockChooserControllerView&) = delete;
  ~MockChooserControllerView() override;

  // ChooserController::View
  MOCK_METHOD0(OnOptionsInitialized, void());
  MOCK_METHOD1(OnOptionAdded, void(size_t index));
  MOCK_METHOD1(OnOptionRemoved, void(size_t index));
  MOCK_METHOD1(OnOptionUpdated, void(size_t index));
  MOCK_METHOD1(OnAdapterEnabledChanged, void(bool enabled));
  MOCK_METHOD1(OnRefreshStateChanged, void(bool enabled));
};

#endif  // CHROME_BROWSER_CHOOSER_CONTROLLER_MOCK_CHOOSER_CONTROLLER_VIEW_H_
