/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* SAMLSubjectStatement.cpp - SAML subject statement implementation

   Scott Cantor
   5/23/02

   $History:$
*/

#include "internal.h"

using namespace saml;
using namespace std;


SAMLSubjectStatement::SAMLSubjectStatement(SAMLSubject* subject) : m_subject(subject)
{
    RTTI(SAMLSubjectStatement);
    if (subject)
        subject->setParent(this);
}

SAMLSubjectStatement::SAMLSubjectStatement(DOMElement* e) : m_subject(NULL)
{
    RTTI(SAMLSubjectStatement);
    fromDOM(e);
}

SAMLSubjectStatement::SAMLSubjectStatement(istream& in) : SAMLStatement(in), m_subject(NULL)
{
    RTTI(SAMLSubjectStatement);
    fromDOM(m_document->getDocumentElement());
}

SAMLSubjectStatement::~SAMLSubjectStatement()
{
    delete m_subject;
}

void SAMLSubjectStatement::fromDOM(DOMElement* e)
{
    SAMLObject::fromDOM(e);
    m_subject=new SAMLSubject(XML::getFirstChildElement(e));
    m_subject->setParent(this);
}

void SAMLSubjectStatement::setSubject(SAMLSubject* subject)
{
    if (subject) {
        delete m_subject;
        m_subject=NULL;
        m_subject = static_cast<SAMLSubject*>(subject->setParent(this));
        ownStrings();
        setDirty();
    }
    else
        throw MalformedException("subject cannot be null");
}

DOMNode* SAMLSubjectStatement::toDOM(DOMDocument* doc, bool xmlns) const
{
    SAMLObject::toDOM(doc, xmlns);
    if (m_bDirty)
        m_root->appendChild(m_subject->toDOM(m_root->getOwnerDocument(),false));
    return m_root;
}

void SAMLSubjectStatement::checkValidity() const
{
    if (!m_subject)
        throw MalformedException("SubjectStatement is invalid, requires subject");
}
