#!/usr/bin/python
#
# extract gettext pot file from .glade files
#


from xmllib import *
import sys



class GladeParser(XMLParser):
    def __init__(self, **kw):
        apply(XMLParser.__init__, (self,), kw)
        self.ok= None
        self.msgs= []
        
    def start_property(self, attrs):
        if attrs.get("translatable",None)=="yes":
            self.ok=""
    def end_property(self):
        if self.ok:
            if self.ok not in self.msgs:
                self.msgs.append(self.ok)

        self.ok=None
    def handle_data(self, data):
        if self.ok is not None:
            self.ok=self.ok+data

for f in sys.argv[1:]:
    parser=GladeParser(accepts_utf8=1)
    parser.feed(open(f).read())
    parser.close()

    for msg in parser.msgs:
        s=""
        if "\n" in msg:
            for line in msg.split("\n"):
                s+= '\\n"\n'+'\t"%s'%line
            s+='"'
            s=s.split("\t",1)[1]
        else:
            s='"%s"'%msg
        
        print "gchar *s= N_("+s+");"
