/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PreviewFrame
extends JFrame
implements PreferenceNames {
    public static final String MODULE = "PreviewFrame";
    SmartHashtable imageIcons = new SmartHashtable();
    ImageIcon imageShowNow = null;
    Picture pictureShowWant = null;
    Picture pictureShowNow = null;
    PreviewLoader previewLoader = new PreviewLoader();
    int previewCacheSize = 10;
    boolean ignoreIMFailure = false;
    CancellableTransferListener listener = null;
    Rectangle imageRect = null;
    public static final Color darkGray = new Color(64, 64, 64, 128);

    public void initComponents() {
        this.setTitle(GRI18n.getString(MODULE, "title"));
        this.setIconImage(GalleryRemote._().getMainFrame().getIconImage());
        this.setBounds(GalleryRemote._().properties.getPreviewBounds());
        this.setContentPane(new ImageContentPane());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PreviewFrame.this.flushMemory();
            }
        });
        this.previewCacheSize = GalleryRemote._().properties.getIntProperty("previewCacheSize");
        CropGlassPane glass = new CropGlassPane();
        this.setGlassPane(glass);
        glass.setVisible(true);
    }

    public void hide() {
        this.flushMemory();
        super.hide();
        this.displayPicture(null, true);
    }

    public void flushMemory() {
        this.imageIcons.clear();
        if (this.pictureShowNow != null) {
            this.pictureShowWant = null;
            this.imageShowNow = null;
            this.displayPicture(this.pictureShowNow, true);
            this.pictureShowNow = null;
        }
    }

    public void displayPicture(Picture picture, boolean async) {
        if (picture == null) {
            this.pictureShowWant = null;
            this.imageRect = null;
            this.pictureReady(null, null);
        } else if (picture != this.pictureShowWant) {
            this.pictureShowWant = picture;
            ImageIcon r = (ImageIcon)this.imageIcons.get(picture);
            if (r != null) {
                Log.log(3, MODULE, "Cache hit: " + picture);
                this.pictureReady(r, picture);
            } else {
                Log.log(3, MODULE, "Cache miss: " + picture);
                if (async) {
                    this.previewLoader.loadPreview(picture, true);
                } else {
                    ImageIcon sizedIcon = this.getSizedIconForce(picture);
                    if (sizedIcon != null) {
                        this.pictureReady(sizedIcon, picture);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageIcon getSizedIconForce(Picture picture) {
        ImageIcon r = (ImageIcon)this.imageIcons.get(picture);
        if (r != null) return r;
        Picture picture2 = picture;
        synchronized (picture2) {
            if (picture.isOnline()) {
                this.pictureStartDownload(picture);
                File f = ImageUtils.download(picture, this.getRootPane().getSize(), GalleryRemote._().getCore().getMainStatusUpdate(), this.listener);
                this.pictureStartProcessing(picture);
                if (f == null) return null;
                r = ImageUtils.load(f.getPath(), this.getRootPane().getSize(), 1, this.ignoreIMFailure);
            } else {
                this.pictureStartProcessing(picture);
                r = ImageUtils.load(picture.getSource().getPath(), this.getRootPane().getSize(), 1, this.ignoreIMFailure);
            }
            Log.log(3, MODULE, "Adding to cache: " + picture);
            this.imageIcons.put(picture, r);
            return r;
        }
    }

    public void pictureReady(ImageIcon image, Picture picture) {
        this.imageShowNow = image;
        this.pictureShowNow = picture;
        this.repaint();
    }

    public void pictureStartDownload(Picture picture) {
    }

    public void pictureStartProcessing(Picture picture) {
    }

    public static void paintOutline(Graphics g, String s, int textX, int textY, int width) {
        g.setColor(darkGray);
        g.drawString(s, textX + width, textY + width);
        g.drawString(s, textX, textY + width);
        g.drawString(s, textX - width, textY + width);
        g.drawString(s, textX + width, textY);
        g.drawString(s, textX, textY);
        g.drawString(s, textX - width, textY);
        g.drawString(s, textX + width, textY - width);
        g.drawString(s, textX, textY - width);
        g.drawString(s, textX - width, textY - width);
        g.setColor(Color.white);
        g.drawString(s, textX, textY);
    }

    class CropGlassPane
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        Color background = new Color(100, 100, 100, 150);
        boolean inDrag;
        Point2D start = null;
        Point2D end = null;
        Point2D moveCropStart = null;
        Rectangle oldRect = null;
        Rectangle cacheRect = null;
        boolean centerMode = false;
        Picture localCurrentPicture = null;
        int movingEdge = 0;
        public static final int TOLERANCE = 5;

        public CropGlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics g) {
            this.oldRect = null;
            if (this.localCurrentPicture != PreviewFrame.this.pictureShowNow) {
                this.cacheRect = null;
                this.localCurrentPicture = PreviewFrame.this.pictureShowNow;
            }
            if (PreviewFrame.this.pictureShowNow == null || PreviewFrame.this.imageShowNow == null || PreviewFrame.this.pictureShowNow.isOnline()) {
                this.cacheRect = null;
                return;
            }
            if (PreviewFrame.this.imageRect != null && this.start != null && this.end != null) {
                Rectangle ct = PreviewFrame.this.pictureShowNow.getCropTo();
                if (ct != null) {
                    AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.imageRect, PreviewFrame.this.pictureShowNow.getDimension(), PreviewFrame.this.pictureShowNow.getAngle(), PreviewFrame.this.pictureShowNow.isFlipped());
                    try {
                        this.cacheRect = this.getRect(t.inverseTransform(ct.getLocation(), null), t.inverseTransform(new Point(ct.x + ct.width, ct.y + ct.height), null));
                        g.setColor(this.background);
                        g.setClip(PreviewFrame.this.imageRect);
                        g.fillRect(0, 0, this.cacheRect.x, this.getHeight());
                        g.fillRect(this.cacheRect.x, 0, this.getWidth() - this.cacheRect.x, this.cacheRect.y);
                        g.fillRect(this.cacheRect.x, this.cacheRect.y + this.cacheRect.height, this.getWidth() - this.cacheRect.x, this.getHeight() - this.cacheRect.y - this.cacheRect.height);
                        g.fillRect(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y, this.getWidth() - this.cacheRect.x - this.cacheRect.width, this.cacheRect.height);
                        g.setColor(Color.black);
                        g.drawRect(this.cacheRect.x, this.cacheRect.y, this.cacheRect.width, this.cacheRect.height);
                        g.setClip(null);
                    }
                    catch (NoninvertibleTransformException e) {
                        Log.logException(1, PreviewFrame.MODULE, e);
                    }
                } else if (this.movingEdge == 0) {
                    this.cacheRect = null;
                }
            } else {
                this.cacheRect = null;
            }
            this.paintInfo(g);
        }

        public void paintInfo(Graphics g) {
            String message = null;
            Rectangle cropTo = PreviewFrame.this.pictureShowNow.getCropTo();
            message = !this.inDrag ? (cropTo == null ? GRI18n.getString(PreviewFrame.MODULE, "noCrop") : GRI18n.getString(PreviewFrame.MODULE, "crop")) : (this.movingEdge == 0 ? GRI18n.getString(PreviewFrame.MODULE, "inCrop") : GRI18n.getString(PreviewFrame.MODULE, "inModify"));
            g.setFont(g.getFont());
            PreviewFrame.paintOutline(g, message, 5, this.getBounds().height - 5, 1);
        }

        public void updateRect() {
            Graphics g = this.getGraphics();
            if (this.oldRect != null) {
                g.setXORMode(Color.cyan);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
            }
            if (this.inDrag) {
                g.setXORMode(Color.cyan);
                this.oldRect = this.getRect(this.start, this.end);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (PreviewFrame.this.pictureShowNow == null) {
                return;
            }
            PreviewFrame.this.pictureShowNow.setCropTo(null);
            this.cacheRect = null;
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (PreviewFrame.this.pictureShowNow == null || PreviewFrame.this.imageRect == null || PreviewFrame.this.pictureShowNow.isOnline()) {
                return;
            }
            if (this.cacheRect == null) {
                this.movingEdge = 0;
            }
            this.inDrag = true;
            switch (this.movingEdge) {
                case 1: {
                    this.start = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height));
                    break;
                }
                case 3: {
                    this.start = this.validate(new Point(this.cacheRect.x, this.cacheRect.y));
                    break;
                }
                case 2: {
                    this.start = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height));
                    break;
                }
                case 4: {
                    this.start = this.validate(new Point(this.cacheRect.x, this.cacheRect.y));
                    break;
                }
                case 5: {
                    this.moveCropStart = this.validate(e.getPoint());
                    break;
                }
                default: {
                    this.start = this.validate(e.getPoint());
                }
            }
            PreviewFrame.this.pictureShowNow.setCropTo(null);
            this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.inDrag = false;
            this.centerMode = false;
            if (PreviewFrame.this.pictureShowNow == null || this.oldRect == null || PreviewFrame.this.pictureShowNow.isOnline()) {
                return;
            }
            AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.imageRect, PreviewFrame.this.pictureShowNow.getDimension(), PreviewFrame.this.pictureShowNow.getAngle(), PreviewFrame.this.pictureShowNow.isFlipped());
            Rectangle tmpRect = new Rectangle();
            tmpRect.setFrameFromDiagonal(t.transform(this.oldRect.getLocation(), null), t.transform(new Point(this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height), null));
            PreviewFrame.this.pictureShowNow.setCropTo(tmpRect);
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            Point2D p;
            if (PreviewFrame.this.imageRect == null) {
                return;
            }
            if (this.cacheRect == null) {
                this.movingEdge = 0;
            }
            int modifiers = e.getModifiersEx();
            switch (this.movingEdge) {
                case 1: {
                    p = this.validate(new Point(this.cacheRect.x, (int)e.getPoint().getY()));
                    modifiers = 0;
                    break;
                }
                case 3: {
                    p = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, (int)e.getPoint().getY()));
                    modifiers = 0;
                    break;
                }
                case 2: {
                    p = this.validate(new Point((int)e.getPoint().getX(), this.cacheRect.y));
                    modifiers = 0;
                    break;
                }
                case 4: {
                    p = this.validate(new Point((int)e.getPoint().getX(), this.cacheRect.y + this.cacheRect.height));
                    modifiers = 0;
                    break;
                }
                case 5: {
                    double dx = e.getPoint().getX() - this.moveCropStart.getX();
                    double dy = e.getPoint().getY() - this.moveCropStart.getY();
                    this.start = this.validate(new Point((int)((double)this.cacheRect.x + dx), (int)((double)this.cacheRect.y + dy)));
                    p = new Point((int)((double)(this.cacheRect.x + this.cacheRect.width) + dx), (int)((double)(this.cacheRect.y + this.cacheRect.height) + dy));
                    modifiers = 0;
                    break;
                }
                default: {
                    p = this.validate(e.getPoint());
                }
            }
            double px = p.getX();
            double py = p.getY();
            if ((modifiers & 0x40) == 64) {
                double dx = px - this.start.getX();
                double dy = py - this.start.getY();
                if (Math.abs(dx) < Math.abs(dy)) {
                    py = this.start.getY() + (dy * dx > 0.0 ? dx : -dx);
                } else {
                    px = this.start.getX() + (dx * dy > 0.0 ? dy : -dy);
                }
                p.setLocation(px, py);
            } else if ((modifiers & 0x80) == 128) {
                int dx = (int)(px - this.start.getX());
                int dy = (int)(py - this.start.getY());
                int sameOrientation = (Math.abs(dx) - Math.abs(dy)) * (PreviewFrame.this.imageRect.width - PreviewFrame.this.imageRect.height);
                Dimension target = sameOrientation > 0 ? new Dimension(dx, dy) : new Dimension(dy, dx);
                Dimension d = ImageUtils.getSizeKeepRatio(PreviewFrame.this.imageRect.getSize(), target, false);
                if (sameOrientation > 0) {
                    p.setLocation(this.start.getX() + (double)d.width, this.start.getY() + (double)d.height);
                } else {
                    p.setLocation(this.start.getX() + (double)d.height, this.start.getY() + (double)d.width);
                }
            }
            this.centerMode = (modifiers & 0x200) == 512;
            this.end = this.validate(p);
            this.updateRect();
        }

        public void mouseMoved(MouseEvent e) {
            if (PreviewFrame.this.pictureShowNow == null || PreviewFrame.this.imageShowNow == null || PreviewFrame.this.pictureShowNow.isOnline() || this.cacheRect == null) {
                this.movingEdge = 0;
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            double px = e.getPoint().getX();
            double py = e.getPoint().getY();
            boolean canMove = false;
            if (px >= (double)(this.cacheRect.x + 5) && px <= (double)(this.cacheRect.x + this.cacheRect.width - 5)) {
                if (Math.abs(py - (double)this.cacheRect.y) < 5.0) {
                    this.movingEdge = 1;
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    canMove = true;
                } else if (Math.abs(py - (double)this.cacheRect.y - (double)this.cacheRect.height) < 5.0) {
                    this.movingEdge = 3;
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    canMove = true;
                }
            }
            if (py >= (double)(this.cacheRect.y + 5) && py <= (double)(this.cacheRect.y + this.cacheRect.height - 5)) {
                if (Math.abs(px - (double)this.cacheRect.x) < 5.0) {
                    this.movingEdge = 2;
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    canMove = true;
                } else if (Math.abs(px - (double)this.cacheRect.x - (double)this.cacheRect.width) < 5.0) {
                    this.movingEdge = 4;
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    canMove = true;
                }
            }
            if (px >= (double)(this.cacheRect.x + 5) && px <= (double)(this.cacheRect.x + this.cacheRect.width - 5) && py >= (double)(this.cacheRect.y + 5) && py <= (double)(this.cacheRect.y + this.cacheRect.height - 5)) {
                this.movingEdge = 5;
                this.setCursor(Cursor.getPredefinedCursor(13));
                canMove = true;
            }
            if (!canMove) {
                this.movingEdge = 0;
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public Rectangle getRect(Point2D p1, Point2D p2) {
            Rectangle r = new Rectangle();
            if (this.centerMode) {
                r.setFrameFromCenter(p1, p2);
                p1 = new Point2D.Double(r.getMinX(), r.getMinY());
                p2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
            }
            r.setFrameFromDiagonal(this.validate(p1), this.validate(p2));
            return r;
        }

        public Point2D validate(Point2D p) {
            double px = p.getX();
            double py = p.getY();
            if (px < (double)PreviewFrame.this.imageRect.x) {
                px = PreviewFrame.this.imageRect.x;
            }
            if (py < (double)PreviewFrame.this.imageRect.y) {
                py = PreviewFrame.this.imageRect.y;
            }
            if (px > (double)(PreviewFrame.this.imageRect.x + PreviewFrame.this.imageRect.width - 1)) {
                px = PreviewFrame.this.imageRect.x + PreviewFrame.this.imageRect.width - 1;
            }
            if (py > (double)(PreviewFrame.this.imageRect.y + PreviewFrame.this.imageRect.height - 1)) {
                py = PreviewFrame.this.imageRect.y + PreviewFrame.this.imageRect.height - 1;
            }
            return new Point2D.Double(px, py);
        }
    }

    public class SmartHashtable
    extends HashMap {
        ArrayList touchOrder = new ArrayList();

        public Object put(Object key, Object value) {
            this.touch(key);
            super.put(key, value);
            if (PreviewFrame.this.previewCacheSize > 0 && this.touchOrder.size() > PreviewFrame.this.previewCacheSize) {
                this.shrink();
            }
            return value;
        }

        public Object get(Object key) {
            return this.get(key, true);
        }

        public Object get(Object key, boolean touch) {
            Object result = super.get(key);
            if (result != null && touch) {
                this.touch(key);
            }
            return result;
        }

        public void clear() {
            Iterator it = this.values().iterator();
            while (it.hasNext()) {
                ImageIcon i = (ImageIcon)it.next();
                if (i == null) continue;
                i.getImage().flush();
            }
            super.clear();
            this.touchOrder.clear();
            Runtime.getRuntime().gc();
        }

        public void touch(Object key) {
            Log.log(3, PreviewFrame.MODULE, "touch " + key);
            int i = this.touchOrder.indexOf(key);
            if (i != -1) {
                this.touchOrder.remove(i);
            }
            this.touchOrder.add(key);
        }

        public void shrink() {
            if (this.touchOrder.size() == 0) {
                Log.log(1, PreviewFrame.MODULE, "Empty SmartHashtable");
                return;
            }
            Object key = this.touchOrder.get(0);
            this.touchOrder.remove(0);
            ImageIcon i = (ImageIcon)this.get(key, false);
            if (i != null) {
                i.getImage().flush();
            }
            this.remove(key);
            Runtime.getRuntime().gc();
            Log.log(3, PreviewFrame.MODULE, "Shrunk " + key);
        }
    }

    class PreviewLoader
    implements Runnable {
        Picture picture;
        boolean stillRunning = false;
        boolean notify = false;

        PreviewLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.log(3, PreviewFrame.MODULE, "Starting " + this.picture);
            Picture tmpPicture = null;
            ImageIcon tmpImage = null;
            while (this.picture != null) {
                Picture picture = this.picture;
                synchronized (picture) {
                    tmpPicture = this.picture;
                    this.picture = null;
                }
                tmpImage = PreviewFrame.this.getSizedIconForce(tmpPicture);
                if (tmpImage != null) continue;
                this.notify = false;
            }
            this.stillRunning = false;
            if (this.notify) {
                PreviewFrame.this.pictureReady(tmpImage, tmpPicture);
                this.notify = false;
            }
            Log.log(3, PreviewFrame.MODULE, "Ending");
        }

        public void loadPreview(Picture picture, boolean notify) {
            Log.log(3, PreviewFrame.MODULE, "loadPreview " + picture);
            this.picture = picture;
            if (notify) {
                this.notify = true;
            }
            if (!this.stillRunning) {
                this.stillRunning = true;
                Log.log(3, PreviewFrame.MODULE, "Calling Start");
                new Thread(this).start();
            }
        }
    }

    class ImageContentPane
    extends JPanel {
        ImageContentPane() {
        }

        public void paintComponent(Graphics g) {
            Color c = GalleryRemote._().properties.getColorProperty("slideshowColor");
            if (c != null) {
                g.setColor(c);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (PreviewFrame.this.imageShowNow != null && PreviewFrame.this.pictureShowWant != null) {
                ImageIcon tmpImage = ImageUtils.rotateImageIcon(PreviewFrame.this.imageShowNow, PreviewFrame.this.pictureShowWant.getAngle(), PreviewFrame.this.pictureShowWant.isFlipped(), this);
                PreviewFrame.this.imageRect = new Rectangle(this.getLocation().x + (this.getWidth() - tmpImage.getIconWidth()) / 2, this.getLocation().y + (this.getHeight() - tmpImage.getIconHeight()) / 2, tmpImage.getIconWidth(), tmpImage.getIconHeight());
                tmpImage.paintIcon(PreviewFrame.this.getContentPane(), g, PreviewFrame.this.imageRect.x, PreviewFrame.this.imageRect.y);
            }
        }
    }
}

