#!/usr/bin/perl -w
# distribution boxbackup-0.11rc2 (svn version: 2072)
#  
# Copyright (c) 2003 - 2008
#      Ben Summers and contributors.  All rights reserved.
#  
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All use of this software and associated advertising materials must 
#    display the following acknowledgment:
#        This product includes software developed by Ben Summers.
# 4. The names of the Authors may not be used to endorse or promote
#    products derived from this software without specific prior written
#    permission.
# 
# [Where legally impermissible the Authors do not disclaim liability for 
# direct physical injury or death caused solely by defects in the software 
# unless it is modified by a third party.]
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#  
#  
#  
use strict;

open (EXCEPT, "<../../ExceptionCodes.txt") or die "Can't open ../../ExceptionCodes.txt: $!\n";
open (DOCBOOK, ">ExceptionCodes.xml") or die "Can't open Exceptioncodes.xml for writing: $!\n";

print DOCBOOK <<EOD;
<?xml version="1.0" encoding="UTF-8"?>

<appendix>
    <title>Exception codes</title>

EOD
my $sectionName;
my $sectionNum;
my $sectionDesc;
my $exceptionCode;
my $exceptionShortDesc;
my $exceptionLongDesc;
while(<EXCEPT>)
{
    next if(m/^#/);
    chomp;
    if(m/^EXCEPTION TYPE (\w+) (\d+)/)
    {
        $sectionName = ucfirst(lc($1));
        $sectionNum = $2;
        if($sectionName ne "Common")
        {
            $sectionDesc = "the " . $sectionName;
        }
        else
        {
            $sectionDesc = "any";
        }
        print DOCBOOK <<EOD;
    <section>
      <title>$sectionName Exceptions ($sectionNum)</title>
      
      <para>These are exceptions that can occur in $sectionDesc module
      of the system.</para>
      
      <itemizedlist>
EOD
    }
    
    # The END TYPE line
    if(m/^END TYPE$/)
    {
        print DOCBOOK "      </itemizedlist>\n    </section>\n";
    }
    
    # The actual exceptions
    if(m/(\(\d+\/\d+\)) - (\w+ \w+)(?: - )?(.*)$/)
    {
        $exceptionCode = $1;
        $exceptionShortDesc = $2;
        $exceptionLongDesc = $3;
        
        print DOCBOOK "        <listitem>\n          <para><emphasis role=\"bold\">";
        print DOCBOOK $exceptionCode . ": " . $exceptionShortDesc . "</emphasis>";
        if($exceptionLongDesc ne "")
        {
            print DOCBOOK " -- " . $exceptionLongDesc;
        }
        print DOCBOOK "</para>\n        </listitem>\n";
    }
}

print DOCBOOK "</appendix>\n";

close EXCEPT;
close DOCBOOK;
        