/*
	monotone.c - animate monotone

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

#define RedPercent		0.299
#define GreenPercent	0.587
#define BluePercent		0.114

static XColor monocolors[256];
static long dr[256],dg[256],db[256];
static int mapsize,errf;

static int CheckTone()
{
int i,j;

	j = mapsize;
	for(i = 0; i < j; i++){
		if(	   xcolors[i].red	!= xcolors[i].green
			|| xcolors[i].red	!= xcolors[i].blue
			|| xcolors[i].green != xcolors[i].blue )
			break;
	}

	if(i == j)
		return(0);
	else
		return(1);
}

static void MonotoneColors()
{
int i,j;
double tone;

	j = mapsize;
	for(i = 0; i < j; i++){
		tone = xcolors[i].red   * RedPercent 
			 + xcolors[i].green * GreenPercent 
			 + xcolors[i].blue  * BluePercent;

		monocolors[i].red	= (word)tone;
		monocolors[i].green = (word)tone;
		monocolors[i].blue  = (word)tone;
		monocolors[i].flags = xcolors[i].flags;
		monocolors[i].pixel = xcolors[i].pixel;
		dr[i] = (long)(xcolors[i].red	- monocolors[i].red	);
		dg[i] = (long)(xcolors[i].green - monocolors[i].green);
		db[i] = (long)(xcolors[i].blue	- monocolors[i].blue );
	}
}

#if defined(__STDC__) || defined(__cplusplus)
static void AnimateMonotone(int mode)
#else
static void AnimateMonotone(mode)
int mode;
#endif
{
int i,j,k;

	k = mapsize;

	if(mode){

		for(j = 255; j > 0; j -= app_data.monotoneSteps){

			for(i = 0; i < k; i++){
				fcolors[i].red	=(word)((int)monocolors[i].red	 + dr[i] * j / 255);
				fcolors[i].green=(word)((int)monocolors[i].green + dg[i] * j / 255);
				fcolors[i].blue =(word)((int)monocolors[i].blue	 + db[i] * j / 255);
				fcolors[i].flags=monocolors[i].flags;
				fcolors[i].pixel=monocolors[i].pixel;
			}

			StoreColors(fcolors,mapsize);
			myusleep(app_data.monotoneTicks);
			if(gotSomeAction == True)
				return;
		}

	}
	else{

		for(j = 1; j < 256; j += app_data.monotoneSteps){

			for(i = 0; i < k; i++){
				fcolors[i].red	=(word)((int)monocolors[i].red	 + dr[i] * j / 255);
				fcolors[i].green=(word)((int)monocolors[i].green + dg[i] * j / 255);
				fcolors[i].blue =(word)((int)monocolors[i].blue	 + db[i] * j / 255);
				fcolors[i].flags=monocolors[i].flags;
				fcolors[i].pixel=monocolors[i].pixel;
			}

			StoreColors(fcolors,mapsize);
			myusleep(app_data.monotoneTicks);
			if(gotSomeAction == True)
				return;
		}

	}

}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xmonotoneshow(char *fname)	/* Animate monotone colors */
#else
ActionStatus xmonotoneshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();

	errf = CheckTone();

	if(errf)
		MonotoneColors();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(	(windowWidth - gim.subImageList->width) / 2,
				(windowHeight - gim.subImageList->height) / 2,
				gim.subImageList->width, gim.subImageList->height);

	PreFadeColors(mapsize);
	FadeColors(False, mapsize);
	StoreColors(xcolors, mapsize);

	if(app_data.showFileName)
		raiseFileNameWindow();

	if(errf)
		AnimateMonotone(True);

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxmonotoneshow(char *fname)	/* Animate monotone colors */
#else
void postxmonotoneshow(fname)
char *fname;
#endif
{
	if(errf)
		AnimateMonotone(False);

	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True, mapsize);
}

