/* System includes for zlibc */

#ifndef SYSINCLUDES_H
#define SYSINCLUDES_H

#include "config.h"

#ifdef linux_gnu
/* RMS strikes again */
# ifndef linux
#  define linux
# endif
#endif

#ifdef HAVE_ANSIDECL_H
# include <ansidecl.h>
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
# ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_SYS_STAT_H
# if defined (STAT_C) && defined(__GLIBC__) && __GLIBC__ >= 2
   /* GLIBC redefines its own struct stat.  Use the original one here */
#  include <asm/stat.h>
#  define stat glibc_stat
# endif
# include <sys/stat.h>
# if defined(STAT_C) && defined(__GLIBC__) && __GLIBC__ >= 2
#  undef stat
# endif
#endif
#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif
#ifdef HAVE_STRING_H
# include <string.h>
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#ifdef HAVE_SYSCALL_H
# include <syscall.h>
#endif
#ifdef HAVE_SYS_SYSCALL_H
# include <sys/syscall.h>
#endif
#ifdef HAVE_DLFCN_H
# include <dlfcn.h>
#endif

#ifdef HAVE_FCNTL_H

#define __open oldopen
#define open oldopen1

#include <fcntl.h>

#undef __open
#undef open

#endif


#ifdef HAVE_TIME_H
# include <time.h>
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif
#ifdef HAVE_UTIME_H
# include <utime.h>
#endif
#ifdef HAVE_PWD_H
# include <pwd.h>
#endif

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define HAVE_NAMLEN
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#if STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif


#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifndef HAVE_STRSEP
extern char *strsep();
#endif

#ifdef HAVE_GNU_STABS_H
# include <gnu-stabs.h>
#endif

#include "params.h"
#include "zlibc.h"


#if defined solaris
/* prototypu on Solaris */
int syscall();
#endif

#ifdef aix
# undef SYS_UTIME
# define SYS_UTIMES
#endif

#ifndef MAXPATHLEN
# define MAXPATHLEN 256
#endif

#endif
