/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: wsoundplay.c,v 1.14 1999/11/17 13:16:49 daeron Exp $

*/

#include <unistd.h>
#include <sys/param.h>
#include <wsound.h>

char *ProgName;

extern int checkForFile (char *instrpath);


int
main(int argc, char **argv) 
{
	int	i;
	char	*sndfile = NULL;
	
	ProgName = argv[0];
	SInitializeApplication(argv[0]);
	
	if ((!argv[1] || strstr(argv[1], "-h"))) {
		printf("usage: %s <sound file>\n\r",ProgName);
		exit(1);
	}
	


	sndfile = (char *) malloc(MAXPATHLEN*sizeof(char));
	if (!sndfile) {
		sfatal(SMessageForError(SERR_NOMEMORY));
		return SERR_NOMEMORY;
	}
	
	for (i = 1; i < argc; i++) {
		if (strncmp(argv[i], "/", 1) != 0) {
			getcwd(sndfile, sizeof(char)*MAXPATHLEN);
			strcat(sndfile, "/");
			strcat(sndfile, argv[i]);
			if (checkForFile(sndfile) != 0) {
				strcpy(sndfile, argv[i]);
			}
		}
		else {
			strcpy(sndfile, argv[i]);
		}

		
		if (SPlaySound(sndfile) == -1)
				swarning(SMessageForError(SErrorCode));
	}
	
	free(sndfile);

	SShutdownApplication();
	return 0;
}

