/* lib.h -- library function declarations.
   Copyright (C) 1990, 91, 92, 93, 94 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _WF_LIB_H

#ifdef have_CONFIG_H
#include <config.h>
#endif

/* Gettext. */
#ifdef HAVE_GETTEXT
# include <libintl.h>
# ifdef HAVE_LOCALE_H
#  include <locale.h>
# endif
# define _(string) gettext(string)
# define N_(string) (string)
#else
# define _(string) string
# define N_(string) (string)
# define textdomain(domain)
# define bindtextdomain(package, directory)
# define setlocale(cat, locale)
#endif

/* Multiple arguments. */
#if defined(HAVE_VARARGS_H) && !defined(HAVE_STDARG_H)
# include <varargs.h>
# define VA_START(a, b)  va_start((a))
#else
# include <stdarg.h>
# define VA_START(a, b)  va_start((a), (b))
# define va_alist ...
# define va_dcl
#endif

#if 0
#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t count, const char *fmt, va_alist);
#endif

#ifndef HAVE_VSNPRINTF
int vsnprintf(char *str, size_t count, const char *fmt, va_list arg);
#endif
#endif

#include "string_printf.h"
#include "ostream_printf.h"

#endif
