/* Based on xqcam.c by Paul Chinn <loomer@svpal.org> */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

XShmSegmentInfo XJ_SHMInfo;
Screen *XJ_screen;
Display *XJ_disp;
Window XJ_root,XJ_win;
XImage *XJ_ximage;
XEvent XJ_ev;
GC XJ_gc;
int XJ_screen_num;
unsigned long XJ_white,XJ_black;
int XJ_started=0; 
int XJ_depth;
int XJ_caught_error;
int XJ_width, XJ_height;
int *XJ_greys;

int XJ_error_catcher(Display * d, XErrorEvent * xeev)
{
  ++XJ_caught_error;
  return 0;
}

char *XJ_init(int width, int height, char *window_name, char *icon_name)
{
  XGCValues values;
  XSizeHints hints;
  XWMHints wmhints;
  char *sbuf;
  XTextProperty windowName, iconName;
  int (*old_handler)();
  int i;
  XColor col;

  XJ_width=width;
  XJ_height=height;

  XJ_disp=XOpenDisplay(NULL);
  if(!XJ_disp) {printf("open display failed\n"); return NULL;}
  
  XJ_screen=DefaultScreenOfDisplay(XJ_disp);
  XJ_screen_num=DefaultScreen(XJ_disp);
  XJ_white=XWhitePixel(XJ_disp,XJ_screen_num);
  XJ_black=XBlackPixel(XJ_disp,XJ_screen_num);
  
  XJ_root=DefaultRootWindow(XJ_disp);
  
  XJ_win=XCreateSimpleWindow(XJ_disp,XJ_root,0,0,XJ_width,XJ_height,0,XJ_white,XJ_black);
  if(!XJ_win) {  
    printf("create window failed\n");
    return(NULL); 
  }
  
  /* tell window manager about our window */
  hints.flags=PSize|PMaxSize|PMinSize;
  hints.min_width=hints.max_width=hints.width=XJ_width;
  hints.min_height=hints.max_height=hints.height=XJ_height;
  wmhints.input=True;
  wmhints.flags=InputHint;

  XStringListToTextProperty(&window_name, 1 ,&windowName);
  XStringListToTextProperty(&icon_name, 1 ,&iconName);


  XSetWMProperties(XJ_disp, XJ_win, 
		   &windowName, &iconName,
		   NULL, 0,
		   &hints, &wmhints, NULL);
  
  XSelectInput(XJ_disp, XJ_win, ExposureMask);
  XMapRaised(XJ_disp, XJ_win);
  XNextEvent(XJ_disp, &XJ_ev);
  
  XJ_gc = XCreateGC(XJ_disp, XJ_win, 0, &values);

  old_handler = XSetErrorHandler(XJ_error_catcher);
  XSync(XJ_disp, 0);

  XJ_depth = DefaultDepthOfScreen(XJ_screen);
  XJ_ximage = XShmCreateImage(XJ_disp, DefaultVisual(XJ_disp, XJ_screen_num), 
			   XJ_depth, ZPixmap, NULL, &XJ_SHMInfo, XJ_width, XJ_height);
  if(!XJ_ximage) {
    printf("CreateImage Failed\n");
    return(NULL);
  }
 
  XJ_SHMInfo.shmid=shmget(IPC_PRIVATE, 
		       XJ_ximage->bytes_per_line*XJ_ximage->height,
		       IPC_CREAT|0777);

  if(XJ_SHMInfo.shmid < 0) {
    perror("shmget failed:");
    return (NULL);
  }
 
  sbuf = XJ_ximage->data = XJ_SHMInfo.shmaddr = shmat(XJ_SHMInfo.shmid, 0, 0);

  XShmAttach(XJ_disp, &XJ_SHMInfo);

  XSync(XJ_disp, 0);
  XSetErrorHandler(old_handler);

  if (XJ_caught_error) {
    fprintf(stderr, "Shared memory unavailable, using regular images\n");
    shmdt(XJ_SHMInfo.shmaddr);
    XJ_SHMInfo.shmaddr = 0;

    sbuf = malloc(((XJ_depth + 7) / 8) * XJ_width * XJ_height);
    XJ_ximage = XCreateImage(XJ_disp, DefaultVisual(XJ_disp, XJ_screen_num), 
			  XJ_depth, ZPixmap, 0, sbuf, XJ_width, XJ_height, XJ_depth,
			  XJ_width * ((XJ_depth + 7) / 8));
    if(!XJ_ximage) {
      printf("CreateImage Failed\n");
      return(NULL);
    }
  }
  
  XJ_greys=(int *)malloc(sizeof(int)*256);
  for(i=0; i<256; i++)
  {
   col.red =col.green = col.blue = i * 256;
   if (!XAllocColor(XJ_disp, DefaultColormap(XJ_disp, XJ_screen_num), &col))
    fprintf(stderr,"XAllocColor failed on %d\n",i);
   XJ_greys[i] = col.pixel;
  }
                          
  XJ_started=1;
  return(sbuf);
}


void XJ_exit(void)
{
  if(XJ_started) {
    if (XJ_ximage)
      XDestroyImage(XJ_ximage);
    XShmDetach(XJ_disp, &XJ_SHMInfo);
    if(XJ_SHMInfo.shmaddr)
      shmdt(XJ_SHMInfo.shmaddr);
    if(XJ_SHMInfo.shmid > 0)
      shmctl(XJ_SHMInfo.shmid, IPC_RMID, 0);
  }
}

   
void XJ_show(void)
{
 if (XJ_SHMInfo.shmaddr)
 {
  XShmPutImage(XJ_disp, XJ_win, XJ_gc, XJ_ximage, 0, 0, 0, 0, XJ_width, XJ_height, False);
 } else
 {
  XPutImage(XJ_disp, XJ_win, XJ_gc, XJ_ximage,  0, 0, 0, 0, XJ_width, XJ_height);
 }
 XFlush(XJ_disp);
}
