// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// File:        text.h - interface to text editor
//
// Created:     25 Apr 95   Bernhard Marschall
//
// Changed:     
//
//
//</file>


#ifndef harmony_widgets_text_h
#define harmony_widgets_text_h

#include "libwidgets.h"
#include "textb.h"


//<class>
//
// Name: TextEditor
//
// Purpose: Glyph for editing several line of text
//
// Style name: TextEditor
//
// attributes:  (not already in TextBrowser)
//
//
//</class>

class TextEditor : public TextBrowser {

public:
  TextEditor(                           // constructor
    WidgetKit& kit,                     //   widget kit
    int size = 10                       //   estimation of number of lines
  );

  virtual ~TextEditor();

//   void getText(RString&) const;         // get the whole text (lines separated by '\n')
//   const char* getLine(long i) const;    // get i-th line of text

  void setCursorLine(long line, int sel);
                                        // set cursor to line
  void setCursorCol(int col, int sel);  // set cursor to column

  void insertChar(char);
  void deleteChar();
  void deleteBackward();

  // TextBrowser (InputHandler)
  virtual void showCursor(long line);
  virtual void hideCursor(long line);
  virtual void keystroke(const Event&);
  virtual InputHandler* focus_in();
  virtual void focus_out();
  virtual void pasteSelection(const Event&);

private:
  boolean delbackward_;

  long visibleLines() const;
  void removeNL();
  void deleteSelection();
};

inline void TextEditor::deleteBackward() {
  setCursorCol(cursorcol_-1, 0);
  deleteChar();
}

#endif
