//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:     nonmodaldlg.C
//
// Purpose:
//
// Created:  20.7.93   Gaisbauer Mansuet Juergen
//
// $Id: nonmodaldlg.C,v 1.1 1996/05/21 07:28:22 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: nonmodaldlg.C,v $
// Revision 1.1  1996/05/21 07:28:22  bmarsch
// Initial revision
//

#include "nonmodaldlg.h"

#include <InterViews/display.h>
#include <InterViews/style.h>
#include <InterViews/handler.h>
#include <InterViews/window.h>


class NonModalDialogHandler : public Handler {
public:
  NonModalDialogHandler(Dialog* d) { dialog_ = d; }
  virtual ~NonModalDialogHandler() {}

  virtual boolean event(Event&);

private:
  Dialog* dialog_;
};

boolean NonModalDialogHandler::event(Event&)
{
  dialog_->dismiss(false);
  return true;
}

// --- NonModalDialog ---------------------------------------------------------

NonModalDialog::NonModalDialog(Glyph* g, Style* s)
: Dialog(g, s)
{
  win_ = nil;
}

NonModalDialog::~NonModalDialog()
{
  delete win_;
}

void NonModalDialog::dismiss(boolean accept)
{
  Dialog::dismiss(accept);
  if (win_) {
    win_->unmap();
    win_->display()->sync();
  }
  Resource::unref(this);
}

boolean NonModalDialog::post_at_aligned(Coord x, Coord y, float xalign, float yalign)
{
  if (!win_) {
    win_ = new TransientWindow(this);
    win_->style(new Style(style()));
    win_->wm_delete(new NonModalDialogHandler(this));
  }

  Resource::ref(this); // unreferenced in dismiss()
  win_->place(x, y);
  win_->align(xalign, yalign);
  win_->map();
  win_->display()->sync();

  return true;
}
