/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "LessonController.H"
#include "LEntry.H"
#include "dirs.H"
#include "main.h"
#include "inputcontrol.h"
#include "outputcontrol.h"
#include <wx/wx.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
#include <wx/config.h>

#ifndef LEKTION_H
#define LEKTION_H

class Hauptfenster;
class TtInputControl;
class TtOutputControl;

class Lektion : public wxTimer {
public:
  /* This will use a default lesson defined by index 'lesson'
   * needed for single lesson and class mode
   */
  Lektion(unsigned int lesson, LessonController* controller = 0, int id = wxID_ANY);
  /* This allows to specify a specific file as lesson
   * needed for contest mode
   */
  Lektion(UrlFile& lesson, LessonController* controller = 0, int id = wxID_ANY);
  ~Lektion();

  void Lektion::Notify ();

  //causes on constructor failure
  class LessonLoadedFailed {};

   // Ein neues Zeichen wurde eingegeben
  bool checkInput(int c);

  size_t getCurrentLineLen () { return this->cache[this->line].Len(); };
  size_t getCurrentLinePos () { return this->charpos; };
  long getCurrentPos ();
  void outputFromCache(wxTextCtrl* output, wxUChar specialLineEnd);

  // Benutzer ist am Ende der Lektion angelangt
  void LektionEnde();
  // Lektion abbrechen
  void LektionAbbrechen();
  // Pause
  void Pause();

  inline LEntry GetLessonData() { return LEntry(m_fehler,m_richtig,(time_t)sw.Time()/1000); };

private:
  int m_fehler;
  int m_richtig;

  Hauptfenster* parent;
  TtInputControl* in;
  TtOutputControl* out;

  LessonController* con;
  /* not(!) the lesson index but the lesson "window" id
   * used when calling event pushing function of the
   * LessonController
   */
  int lessonID;

  /* wird bentigt, um zu registieren, ob der aktuelle
   * Buchstabe schonmal falsch eingeben wurde, um diesen
   * dann rot darzustellen
   */
  bool markedCorrect;

  //from transition
  bool m_falsch;
  
  wxStopWatch sw;

  void Init(LessonController* controller = 0);

  // Laden der Lektion
  bool LektionLaden(unsigned int index);
  bool LektionLaden (UrlFile& lesson);

  /* To not have to reread the file on e.g. font change,
   * cache the lines here...
   */
  wxArrayString cache;
  bool fillCache (UrlFile& lesson);
  wxUChar getCharFromCache(unsigned int row, unsigned int column);
  // Position in the cache
  unsigned int line;
  unsigned int charpos;
  void markNextChar (unsigned int row, unsigned int column);

  // Lektionsanweisung anzeigen
  void Lektionsanweisung(unsigned int index);

  // Statusbar control
  void updateStatusbar(const wxString& generic, long wrong, long correct);
  void onTimer(wxTimerEvent& WXUNUSED(e));
};

#endif
