#!/bin/sh

# Run "xmkmf"
# Since invocation of Sun OpenWindow's "xmkmf" is different from 
# X11R* "xmkmf", we need to check how to invoke it.

XMKMF=`../whereisit xmkmf`
if test "X-${XMKMF}" = "X-" ; then 
  # xmkmf not found. 
  echo xmkmf not found.
  rm -f Makefile make-x11 x11-defs.h;
  touch Makefile make-x11 x11-defs.h;
  echo "all: "                        >> Makefile; 
  echo "	@echo X11 NOT FOUND"  >> Makefile; 
  exit;
fi


NO_OPENWIN=`./chkow.sh`

# Run "xmkmf" accroding to the check result.
case ${NO_OPENWIN} in
0)
  echo Use OpenWindow
  xmkmf $OPENWINHOME/lib .
  ;;
1)
  echo No OpenWindow
  echo Running 'xmfmf -a'
  xmkmf -a
  if test "-d /usr/openwin && \( X-${OPENWINHOME+set} = X-set \)" ; then  
    if test X-`../whereisit xmkmf` = X-/usr/openwin/bin/xmkmf ; then
      echo Warning: Probably, you must set an environment variable OPENWINHOME.
    fi
  fi
  ;;
esac


