// Test of template support in Synopsis

//. The base template type
template<typename T, int I = 100>
    class Foo
    {
    public:
	T* t;
	int size() const { return I; }
    };

//. A specialization for a single element
template<typename T>
    class Foo<T,1>
    {
    public:
	T& t;
	int size() const { return 1; }
    };

//. A specialization for integers
template<int I>
    class Foo<int, I>
    {
    public:
	int t[];
	int size() const { return I; }
    };

//. A specialization for integers of size 1
template<>
    class Foo<int, 1>
    {
    public:
	int &t;
	int size() const { return 1; }
    };

//. A class that inherits on a template dependant on itself
class Bar : public Foo<Bar>
{
    //. verbiage
    void IamAfunkyFunction(Bar*);
};
