#!/usr/bin/env python
# A simple synopsis xref file dumper
# Written by Stephen Davies

import sys, string, urllib

if len(sys.argv) != 2:
    print "Usage: dump_xref.py <filename>"
    sys.exit(1)

db_sym, db_ctx = {}, {}

# Open file
input = open(sys.argv[1], 'r')

# Read records
for record in input.readlines():
    symbol, file, line, context, type = string.split(record)
    symbol_list = db_sym.setdefault(symbol, [])
    if type == 'DEF': symbol_list.insert(0, (type, file, line, context))
    else: symbol_list.append((type, file, line, context))
    db_ctx.setdefault(context, []).append((file, line, type, symbol))

input.close()

# Display accumulated database

print "****************************************************************"
print "****        FORWARD REFERENCES"
print "****"

symbols = db_sym.keys()
symbols.sort()

def decode(str):
    str = urllib.unquote(str).replace('\t','::')
    if str == '::': return 'global'
    return str

for symbol in symbols:
    print "\nSymbol:",decode(symbol)
    records = db_sym[symbol]
    for type, file, line, context  in records:
	if type == 'DEF': print "  Defined in %s :%s in %s"%(file, line, decode(context))
	elif type == 'REF': print "  Referenced from %s :%s in %s"%(file, line, decode(context))
	else: print "  Called from %s :%s in %s"%(file, line, decode(context))


print "****************************************************************"
print "****        BACKWARDS REFERENCES"
print "****"

contexts = db_ctx.keys()
contexts.sort()

for context in contexts:
    print "\nContext:",decode(context)
    records = db_ctx[context]
    records.sort()
    for file, line, type, symbol in records:
	if type == 'DEF': print "  %s : %s defines %s"%(file, line, decode(symbol))
	elif type == 'REF': print "  %s : %s references %s"%(file, line, decode(symbol))
	else: print "  %s : %s calls %s"%(file, line, decode(symbol))


