/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: TextEditorPane.java,v $
   Revision 1.3  2004/11/02 11:07:31  bobintetley
   Fixed a number of small compatibility bugs

   Revision 1.2  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.1  2004/10/29 10:24:07  bobintetley
   Separate EditorPane implementations to decouple platform specifics,
   stubbing of HTMLEditorKit



*/

package swingwtx.swing.editorpanes;

import swingwt.awt.Color;
import swingwtx.swing.text.*;
import swingwtx.swing.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.*;

/**
 * An implementation of an editor pane that supports text entry. It will
 * be extended to include colour/font formatting but at present only
 * supports plain text.
 *
 * @author  Robin Rawson-Tetley
 */
public class TextEditorPane extends JTextComponent implements EditorPane {

    protected Document doc = new TextEditorPane.EditorPaneStyledDocument();
    protected Color selectionColor = Color.BLACK;
    protected StyledText ppeer = null;
    protected Object retval = null;
    
    public void addHyperlinkListener(swingwtx.swing.event.HyperlinkListener l) {
    }    
    
    public swingwt.awt.Dimension calculatePreferredSize() {
        // Default 300x200
        swingwt.awt.Dimension size = new swingwt.awt.Dimension(300, 200);
        setSize(size);
        return size;
    }    
    
    public int getCaretPosition() {
        return super.getCaretPosition();
    }
    
    public String getContentType() {
        return "text/plain";
    }
    
    public swingwtx.swing.text.Document getDocument() {
        return doc;
    }
    
    public swingwtx.swing.text.EditorKit getEditorKit() {
        return new StyledEditorKit();
    }
    
    public swingwtx.swing.JComponent getJComponent() {
        return this;
    }
    
    public swingwt.awt.Color getSelectionColor() {
        return selectionColor;
    }
    
    public int getSelectionEnd() {
        return super.getSelectionEnd();
    }
    
    public int getSelectionStart() {
        return super.getSelectionStart();
    }
    
    public Control getSWTPeer() {
        return ppeer;
    }    
    
    public String getText() {
        if (!SwingWTUtils.isSWTControlAvailable(ppeer)) return pText;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                retval = ppeer.getText();
            }
        });
        return retval.toString();
    }
    
    public boolean isEditable() {
        return super.isEditable();
    }
    
    public void removeHyperlinkListener(swingwtx.swing.event.HyperlinkListener l) {
    }
    
    public void setCaretPosition(int pos) {
        super.setCaretPosition(pos);
    }
    
    public void setContentType(String contentType) {
    }
    
    public void setDocument(swingwtx.swing.text.Document newdoc) {
        doc = newdoc;
    }
    
    public void setEditable(boolean b) {
        super.setEditable(b);
    }
    
    public void setEditorKit(swingwtx.swing.text.EditorKit k) {
        throw new RuntimeException("Setting of EditorKit not yet supported");
    }
    
    public void setPage(java.net.URL url) throws java.io.IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }
    
    public void setPage(String url) throws java.io.IOException {
        throw new RuntimeException("Cannot set page in TextEditorPane");
    }
    
    public void setSelectionColor(swingwt.awt.Color color) {
        selectionColor = color;
    }
    
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        
    	int swtFlags = SWT.BORDER;
        swtFlags |= pWordWrap ? SWT.WRAP : SWT.NONE;
        
        if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane) parent;
            boolean useHorizontal = false, useVertical = false;
            switch (scrollPane.getHorizontalScrollBarPolicy()) {
                case JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS:
                    useHorizontal = true;
                    break;
                case JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED:
                    useHorizontal = true;
                    break;
                case JScrollPane.HORIZONTAL_SCROLLBAR_NEVER:
                    break;
                default:
                    useHorizontal = false;
                    break;
            }
            switch (scrollPane.getVerticalScrollBarPolicy()) {
                case JScrollPane.VERTICAL_SCROLLBAR_ALWAYS:
                    useVertical = true;
                    break;
                case JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED:
                    useVertical = true;
                    break;
                case JScrollPane.VERTICAL_SCROLLBAR_NEVER:
                    break;
                default:
                    useVertical = false;
                    break;
            }
            swtFlags |= useHorizontal ? SWT.H_SCROLL : SWT.NONE;
            swtFlags |= useVertical ? SWT.V_SCROLL : SWT.NONE;
        }
    	
        ppeer = new StyledText(parent.getComposite(), swtFlags);
        peer = ppeer;

        // Cached properties
        if (pText != null && !pText.equals("")) ppeer.setText(pText);
        doc = new EditorPaneStyledDocument();
        doc.insertString(0, pText, null);
        
    }
    
    public void setText(String text) {
        pText = text;
        SwingUtilities.invokeAsync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(ppeer))  {
                    ppeer.setText(pText);
                }
            }
        });
    }
    
    
    /**
     * A basic styled document implementation
     */
    private class EditorPaneStyledDocument extends AbstractDocument {
        
        public Element getDefaultRootElement() {
            return null;
        }
        
        public Element getParagraphElement(int pos) {
            return null;
        }
        
        /** TODO: Alter the peers colour/formatting based on the AttributeSet passed in here */
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
        }
    }
    
}
