/*
   SwingWT
   Copyright(c)2004, Daniel Naab

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: dannaab@users.sourceforge.net
 
   $Log: ImageIO.java,v $
   Revision 1.3  2004/10/30 20:11:56  bobintetley
   Code cleanup

   Revision 1.2  2004/05/10 09:22:44  bobintetley
   MediaTracker and ImageIO.read() support

 
*/

package swingwtx.imageio;

import swingwt.awt.image.*;
import swingwtx.swing.*;

import java.net.*;
import java.io.*;

/**
 * Incomplete ImageIO support
 *
 * @author  Naab
 * @version %I%, %G%
 */
public class ImageIO
{
    private static String[] knownImageFormats = new String[] {"bmp", "ico", "jpg", "jpeg", "gif", "png"};
    
    /**
     * Return hardcoded list of known SWT format types.  I'm not aware of a SWT method to return this,
     * but I expect that one exists.
     */
    public static String[] getReaderFormatNames()
    {
        return knownImageFormats;
    }
    
    public static BufferedImage read(InputStream input) throws IOException {
        BufferedImage im = new BufferedImage(0,0,0);
        im.image = new org.eclipse.swt.graphics.Image(SwingWTUtils.getDisplay(), input);
        return im;
    }

    public static BufferedImage read(URL input) throws IOException {
        BufferedImage im = new BufferedImage(0,0,0);
        im.image = new org.eclipse.swt.graphics.Image(SwingWTUtils.getDisplay(), input.openStream());
        return im;
    }
}
