/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.progress.ErrorNotificationManager;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressFeedbackManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressManager
extends ProgressProvider
implements IProgressService {
    private static ProgressManager singleton;
    private final Map jobs = Collections.synchronizedMap(new HashMap());
    private final Collection listeners = Collections.synchronizedList(new ArrayList());
    final Object listenerKey = new Object();
    final ErrorNotificationManager errorManager = new ErrorNotificationManager();
    private final ProgressFeedbackManager feedbackManager = new ProgressFeedbackManager();
    IJobChangeListener changeListener;
    static final String PROGRESS_VIEW_NAME = "org.eclipse.ui.views.ProgressView";
    static final String PROGRESS_FOLDER = "icons/full/progress/";
    private static final String PROGRESS_20 = "progress20.gif";
    private static final String PROGRESS_40 = "progress40.gif";
    private static final String PROGRESS_60 = "progress60.gif";
    private static final String PROGRESS_80 = "progress80.gif";
    private static final String PROGRESS_100 = "progress100.gif";
    private static final String SLEEPING_JOB = "sleeping.gif";
    private static final String WAITING_JOB = "waiting.gif";
    private static final String BLOCKED_JOB = "lockedstate.gif";
    private static final String BUSY_OVERLAY = "progressspin.gif";
    private static final String MAXIMIZE = "maximize.gif";
    private static final String MINIMIZE = "minimize.gif";
    private static final String PROGRESS_20_KEY = "PROGRESS_20";
    private static final String PROGRESS_40_KEY = "PROGRESS_40";
    private static final String PROGRESS_60_KEY = "PROGRESS_60";
    private static final String PROGRESS_80_KEY = "PROGRESS_80";
    private static final String PROGRESS_100_KEY = "PROGRESS_100";
    public static final String SLEEPING_JOB_KEY = "SLEEPING_JOB";
    public static final String WAITING_JOB_KEY = "WAITING_JOB";
    public static final String BLOCKED_JOB_KEY = "LOCKED_JOB";
    public static final String BUSY_OVERLAY_KEY = "BUSY_OVERLAY";
    public static final String MINIMIZE_KEY = "MINIMIZE_FLOATING";
    public static final String MAXIMIZE_KEY = "MAXIMIZE_FLOATING";
    static final String[] keys;
    final Hashtable runnableMonitors = new Hashtable();

    static {
        keys = new String[]{PROGRESS_20_KEY, PROGRESS_40_KEY, PROGRESS_60_KEY, PROGRESS_80_KEY, PROGRESS_100_KEY};
    }

    public static ProgressManager getInstance() {
        if (singleton == null) {
            singleton = new ProgressManager();
        }
        return singleton;
    }

    public static Image getProgressImageFor(int done) {
        int index = Math.min(4, done / 20);
        return JFaceResources.getImage((String)keys[index]);
    }

    ProgressManager() {
        Platform.getJobManager().setProgressProvider((ProgressProvider)this);
        this.createChangeListener();
        Platform.getJobManager().addJobChangeListener(this.changeListener);
        URL iconsRoot = Platform.getPlugin((String)"org.eclipse.ui").find((IPath)new Path(PROGRESS_FOLDER));
        try {
            this.setUpImage(iconsRoot, PROGRESS_20, PROGRESS_20_KEY);
            this.setUpImage(iconsRoot, PROGRESS_40, PROGRESS_40_KEY);
            this.setUpImage(iconsRoot, PROGRESS_60, PROGRESS_60_KEY);
            this.setUpImage(iconsRoot, PROGRESS_80, PROGRESS_80_KEY);
            this.setUpImage(iconsRoot, PROGRESS_100, PROGRESS_100_KEY);
            this.setUpImage(iconsRoot, SLEEPING_JOB, SLEEPING_JOB_KEY);
            this.setUpImage(iconsRoot, WAITING_JOB, WAITING_JOB_KEY);
            this.setUpImage(iconsRoot, BLOCKED_JOB, BLOCKED_JOB_KEY);
            this.setUpImage(iconsRoot, BUSY_OVERLAY, BUSY_OVERLAY_KEY);
            this.setUpImage(iconsRoot, MAXIMIZE, MAXIMIZE_KEY);
            this.setUpImage(iconsRoot, MINIMIZE, MINIMIZE_KEY);
            this.errorManager.setUpImages(iconsRoot);
        }
        catch (MalformedURLException e) {
            ProgressManagerUtil.logException(e);
        }
    }

    private void createChangeListener() {
        this.changeListener = new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                JobInfo info = ProgressManager.this.getJobInfo(event.getJob());
                ProgressManager.this.refreshJobInfo(info);
            }

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                JobInfo info = ProgressManager.this.getJobInfo(event.getJob());
                if (event.getResult().getSeverity() == 4) {
                    ProgressManager.this.errorManager.addError(event.getResult(), event.getJob().getName());
                }
                ProgressManager.this.jobs.remove(event.getJob());
                ProgressManager.this.removeJobInfo(info);
                if (ProgressManager.this.hasNoRegularJobInfos() && !ProgressManager.this.isNonDisplayableJob(event.getJob(), false)) {
                    ProgressManager.this.refreshAll();
                }
            }

            public void scheduled(IJobChangeEvent event) {
                if (ProgressManager.this.isNeverDisplayedJob(event.getJob())) {
                    return;
                }
                if (ProgressManager.this.jobs.containsKey(event.getJob())) {
                    ProgressManager.this.refreshJobInfo(ProgressManager.this.getJobInfo(event.getJob()));
                } else {
                    ProgressManager.this.addJobInfo(new JobInfo(event.getJob()));
                }
            }
        };
    }

    private void setUpImage(URL iconsRoot, String fileName, String key) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, fileName)));
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.progressFor(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed() && display.getThread() == Thread.currentThread()) {
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        return super.getDefaultMonitor();
    }

    private JobMonitor progressFor(Job job) {
        if (this.runnableMonitors.containsKey(job)) {
            return (JobMonitor)this.runnableMonitors.get(job);
        }
        return new JobMonitor(job);
    }

    void addListener(IJobProgressManagerListener listener) {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    void removeListener(IJobProgressManagerListener listener) {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    JobInfo getJobInfo(Job job) {
        JobInfo info = (JobInfo)this.jobs.get(job);
        if (info == null) {
            info = new JobInfo(job);
            this.jobs.put(job, info);
        }
        return info;
    }

    public void refreshJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.refreshGroup(group);
        }
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.refreshJobInfo(info);
            }
        }
    }

    public void refreshGroup(GroupInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                listener.refreshGroup(info);
            }
        }
    }

    public void refreshAll() {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                listener.refreshAll();
            }
        }
    }

    public void removeJobInfo(JobInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            this.jobs.remove(info.getJob());
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.removeJob(info);
            }
        }
    }

    public void removeGroup(GroupInfo group) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                listener.removeGroup(group);
            }
        }
    }

    public void addJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.refreshGroup(group);
        }
        Object object = this.listenerKey;
        synchronized (object) {
            this.jobs.put(info.getJob(), info);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                if (this.isNonDisplayableJob(info.getJob(), listener.showsDebug())) continue;
                listener.addJob(info);
            }
        }
    }

    public void addGroup(GroupInfo info) {
        Object object = this.listenerKey;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IJobProgressManagerListener listener = (IJobProgressManagerListener)iterator.next();
                listener.addGroup(info);
            }
        }
    }

    boolean isNonDisplayableJob(Job job, boolean debug) {
        if (this.isNeverDisplayedJob(job)) {
            return true;
        }
        if (debug) {
            return false;
        }
        return job.isSystem() || job.getState() == 1;
    }

    private boolean isNeverDisplayedJob(Job job) {
        return job == null;
    }

    public JobInfo[] getJobInfos(boolean debug) {
        Map map = this.jobs;
        synchronized (map) {
            Iterator iterator = this.jobs.keySet().iterator();
            ArrayList result = new ArrayList();
            while (iterator.hasNext()) {
                Job next = (Job)iterator.next();
                if (this.isNonDisplayableJob(next, debug)) continue;
                result.add(this.jobs.get(next));
            }
            JobInfo[] infos = new JobInfo[result.size()];
            result.toArray(infos);
            return infos;
        }
    }

    public JobTreeElement[] getRootElements(boolean debug) {
        Map map = this.jobs;
        synchronized (map) {
            Iterator iterator = this.jobs.keySet().iterator();
            HashSet<JobTreeElement> result = new HashSet<JobTreeElement>();
            while (iterator.hasNext()) {
                Job next = (Job)iterator.next();
                if (this.isNonDisplayableJob(next, debug)) continue;
                JobInfo jobInfo = (JobInfo)this.jobs.get(next);
                GroupInfo group = jobInfo.getGroupInfo();
                if (group == null) {
                    result.add(jobInfo);
                    continue;
                }
                result.add(group);
            }
            JobTreeElement[] infos = new JobTreeElement[result.size()];
            result.toArray(infos);
            return infos;
        }
    }

    public boolean hasJobInfos() {
        Map map = this.jobs;
        synchronized (map) {
            block4: {
                Iterator iterator = this.jobs.keySet().iterator();
                if (!iterator.hasNext()) break block4;
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasNoRegularJobInfos() {
        Map map = this.jobs;
        synchronized (map) {
            Job next;
            Iterator iterator = this.jobs.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.isNonDisplayableJob(next = (Job)iterator.next(), false));
            return false;
        }
    }

    Image getImage(ImageData source) {
        ImageData mask = source.getTransparencyMask();
        return new Image(null, source, mask);
    }

    ImageData[] getImageData(URL fileSystemPath, ImageLoader loader) {
        try {
            InputStream stream = fileSystemPath.openStream();
            ImageData[] result = loader.load(stream);
            stream.close();
            return result;
        }
        catch (FileNotFoundException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
        catch (IOException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
    }

    public IStatus requestInUI(UIJob job, String message) {
        return this.feedbackManager.requestInUI(job, message);
    }

    ProgressFeedbackManager getFeedbackManager() {
        return this.feedbackManager;
    }

    public void busyCursorWhile(final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        final ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(null);
        dialog.setOpenOnRun(false);
        this.scheduleProgressMonitorJob(dialog);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        final InvocationTargetException[] invokes = new InvocationTargetException[1];
        final InterruptedException[] interrupt = new InterruptedException[1];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                try {
                    dialog.setOpenOnRun(false);
                    dialog.run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    invokes[0] = e;
                }
                catch (InterruptedException e) {
                    interrupt[0] = e;
                }
            }
        });
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }

    private void scheduleProgressMonitorJob(final ProgressMonitorJobsDialog dialog) {
        WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.getString("ProgressManager.openJobName")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Display currentDisplay = this.getDisplay();
                if (currentDisplay == null || currentDisplay.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                Shell[] shells = currentDisplay.getShells();
                int modal = 229376;
                int i = 0;
                while (i < shells.length) {
                    int style;
                    if (shells[i].isVisible() && ((style = shells[i].getStyle()) & modal) != 0) {
                        this.schedule(5000L);
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                dialog.open();
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule(5000L);
    }

    public void shutdown() {
        Object object = this.listenerKey;
        synchronized (object) {
            this.listeners.clear();
        }
        Platform.getJobManager().setProgressProvider(null);
        Platform.getJobManager().removeJobChangeListener(this.changeListener);
    }

    public IProgressMonitor createProgressGroup() {
        return new GroupInfo();
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        JobMonitor monitor = this.progressFor(job);
        if (group instanceof GroupInfo) {
            GroupInfo groupInfo = (GroupInfo)group;
            JobInfo jobInfo = this.getJobInfo(job);
            jobInfo.setGroupInfo(groupInfo);
            jobInfo.setTicks(ticks);
            groupInfo.addJobInfo(jobInfo);
        }
        return monitor;
    }

    private class JobMonitor
    implements IProgressMonitorWithBlocking {
        Job job;
        String currentTaskName;

        JobMonitor(Job newJob) {
            this.job = newJob;
        }

        public void beginTask(String taskName, int totalWork) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.beginTask(taskName, totalWork);
            ProgressManager.this.refreshJobInfo(info);
            this.currentTaskName = taskName;
        }

        public void done() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.clearTaskInfo();
            info.clearChildren();
            ProgressManager.this.runnableMonitors.remove(this);
        }

        public void internalWorked(double work) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (info.hasTaskInfo()) {
                info.addWork(work);
                ProgressManager.this.refreshJobInfo(info);
            }
        }

        public boolean isCanceled() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            return info.isCanceled();
        }

        public void setCanceled(boolean value) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (value && !info.isCanceled()) {
                info.cancel();
            }
        }

        public void setTaskName(String taskName) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            if (!info.hasTaskInfo()) {
                this.beginTask(taskName, 100);
                return;
            }
            info.setTaskName(taskName);
            info.clearChildren();
            ProgressManager.this.refreshJobInfo(info);
            this.currentTaskName = taskName;
        }

        public void subTask(String name) {
            if (name.length() == 0) {
                return;
            }
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.clearChildren();
            info.addSubTask(name);
            ProgressManager.this.refreshJobInfo(info);
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(null);
            ProgressManager.this.refreshJobInfo(info);
        }

        public void setBlocked(IStatus reason) {
            JobInfo info = ProgressManager.this.getJobInfo(this.job);
            info.setBlockedStatus(null);
            ProgressManager.this.refreshJobInfo(info);
        }
    }
}

