/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.TabFolderLayout;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class BasicStackPresentation
extends StackPresentation {
    private CTabFolder tabFolder;
    private IPresentablePart current;
    private boolean activeState = false;
    private int tabPosition;
    private MenuManager systemMenuManager = new MenuManager();
    private TabFolderLayout layout;
    private Label titleLabel;
    private Listener dragListener;
    private Color backgroundGradientStart;
    private Color backgroundGradientEnd;
    private Color background;
    private int mousedownState = -1;
    private static final String TAB_DATA;
    private CTabFolder2Adapter expandListener = new CTabFolder2Adapter(){

        public void minimize(CTabFolderEvent event) {
            event.doit = false;
            if (BasicStackPresentation.this.mousedownState == BasicStackPresentation.this.getSite().getState()) {
                BasicStackPresentation.this.getSite().setState(0);
            }
        }

        public void restore(CTabFolderEvent event) {
            event.doit = false;
            BasicStackPresentation.this.getSite().setState(2);
        }

        public void maximize(CTabFolderEvent event) {
            event.doit = false;
            BasicStackPresentation.this.getSite().setState(1);
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.widget instanceof Control) {
                CTabItem oldItem;
                Control ctrl = (Control)e.widget;
                Point globalPos = ctrl.toDisplay(new Point(e.x, e.y));
                BasicStackPresentation.this.mousedownState = BasicStackPresentation.this.getSite().getState();
                CTabItem newItem = BasicStackPresentation.this.tabFolder.getItem(BasicStackPresentation.this.tabFolder.toControl(globalPos));
                if (newItem != null && newItem != (oldItem = BasicStackPresentation.this.tabFolder.getSelection())) {
                    return;
                }
                if (BasicStackPresentation.this.current != null) {
                    BasicStackPresentation.this.current.setFocus();
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (BasicStackPresentation.this.getSite().getState() == 1) {
                BasicStackPresentation.this.getSite().setState(2);
            } else {
                BasicStackPresentation.this.getSite().setState(1);
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point pos = new Point(event.x, event.y);
            CTabItem item = BasicStackPresentation.this.tabFolder.getItem(pos);
            IPresentablePart part = null;
            if (item != null) {
                part = BasicStackPresentation.this.getPartForTab(item);
            }
            BasicStackPresentation.this.showSystemMenu(part, pos);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event e) {
            IPresentablePart item = BasicStackPresentation.this.getPartForTab((CTabItem)e.item);
            if (item != null) {
                BasicStackPresentation.this.getSite().selectPart(item);
            }
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event e) {
            BasicStackPresentation.this.setControlSize();
        }
    };
    private CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

        public void close(CTabFolderEvent event) {
            event.doit = false;
            IPresentablePart part = BasicStackPresentation.this.getPartForTab((CTabItem)event.item);
            BasicStackPresentation.this.getSite().close(part);
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (source instanceof IPresentablePart) {
                IPresentablePart part = (IPresentablePart)source;
                BasicStackPresentation.this.childPropertyChanged(part, property);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget instanceof CTabItem) {
                CTabItem item = (CTabItem)e.widget;
                IPresentablePart part = BasicStackPresentation.this.getPartForTab(item);
                part.removePropertyListener(BasicStackPresentation.this.childPropertyChangeListener);
            }
        }
    };
    private ToolBar viewToolBar;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.presentations.BasicStackPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAB_DATA = String.valueOf(clazz.getName()) + ".partId";
    }

    public int getTopTrimStart() {
        return this.layout.getTrimStart();
    }

    public BasicStackPresentation(CTabFolder control, IStackPresentationSite stackSite) {
        super(stackSite);
        this.tabFolder = control;
        this.layout = new TabFolderLayout(this.tabFolder);
        this.titleLabel = new Label(control.getParent(), 64);
        this.titleLabel.setVisible(false);
        this.viewToolBar = new ToolBar(control.getParent(), 8388928);
        ToolItem pullDownButton = new ToolItem(this.viewToolBar, 8);
        Image hoverImage = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_HOVER");
        pullDownButton.setDisabledImage(hoverImage);
        pullDownButton.setImage(hoverImage);
        pullDownButton.setToolTipText(WorkbenchMessages.getString("Menu"));
        pullDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicStackPresentation.this.showPaneMenu();
            }
        });
        this.tabFolder.addListener(13, this.selectionListener);
        this.tabFolder.addListener(11, this.resizeListener);
        this.tabFolder.addMouseListener(this.mouseListener);
        this.tabFolder.addListener(35, this.menuListener);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)this.closeListener);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)this.expandListener);
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
                Point localPos = new Point(event.x, event.y);
                if ((BasicStackPresentation.this.tabFolder.getStyle() & 0x80) != 0 ? localPos.y > BasicStackPresentation.this.tabFolder.getTabHeight() : localPos.y < ((BasicStackPresentation)BasicStackPresentation.this).tabFolder.getBounds().height - BasicStackPresentation.this.tabFolder.getTabHeight()) {
                    return;
                }
                CTabItem tabUnderPointer = BasicStackPresentation.this.tabFolder.getItem(localPos);
                if (tabUnderPointer == null) {
                    BasicStackPresentation.this.getSite().dragStart(BasicStackPresentation.this.tabFolder.toDisplay(localPos), false);
                    return;
                }
                IPresentablePart part = BasicStackPresentation.this.getPartForTab(tabUnderPointer);
                if (BasicStackPresentation.this.getSite().isMoveable(part)) {
                    BasicStackPresentation.this.getSite().dragStart(part, BasicStackPresentation.this.tabFolder.toDisplay(localPos), false);
                }
            }
        };
        PresentationUtil.addDragListener((Control)this.tabFolder, this.dragListener);
        this.titleLabel.addMouseListener(this.mouseListener);
        int toolbarHeight = this.viewToolBar.computeSize((int)-1, (int)-1).y;
        int tabHeight = toolbarHeight + this.layout.differenceBetweenTabHeightAndTrimRegion();
        if (tabHeight < 20) {
            tabHeight = 20;
        }
        this.tabFolder.setTabHeight(tabHeight);
    }

    public void showPaneMenu() {
        IPartMenu menu = this.getPartMenu();
        if (menu != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.viewToolBar);
            menu.showMenu(new Point(bounds.x, bounds.y + bounds.height));
        }
    }

    protected IPresentablePart getCurrent() {
        return this.current;
    }

    private final int indexOf(IPresentablePart part) {
        if (part == null) {
            return this.tabFolder.getItemCount();
        }
        CTabItem[] items = this.tabFolder.getItems();
        int idx = 0;
        while (idx < items.length) {
            IPresentablePart tabPart = this.getPartForTab(items[idx]);
            if (part == tabPart) {
                return idx;
            }
            ++idx;
        }
        return items.length;
    }

    protected final CTabItem getTab(IPresentablePart part) {
        CTabItem[] items = this.tabFolder.getItems();
        int idx = this.indexOf(part);
        if (idx < items.length) {
            return items[idx];
        }
        return null;
    }

    protected void childPropertyChanged(IPresentablePart part, int property) {
        CTabItem tab = this.getTab(part);
        this.initTab(tab, part);
        switch (property) {
            case 146: {
                FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
                if (part.isBusy()) {
                    tab.setFont(registry.getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
                    break;
                }
                if (this.getCurrent().equals(part)) {
                    tab.setFont(registry.get("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
                    break;
                }
                tab.setFont(registry.getBold("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
                break;
            }
            case 1: 
            case 147: 
            case 770: {
                this.setControlSize();
            }
        }
    }

    protected final IPresentablePart getPartForTab(CTabItem item) {
        IPresentablePart part = (IPresentablePart)item.getData(TAB_DATA);
        return part;
    }

    protected CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabPosition(int position) {
        this.tabPosition = position;
        this.getTabFolder().setTabPosition(this.tabPosition);
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    public void drawGradient(Color fgColor, Color[] bgColors, int[] percentages, boolean vertical) {
        this.tabFolder.setSelectionForeground(fgColor);
        this.tabFolder.setSelectionBackground(bgColors, percentages, vertical);
    }

    public boolean isActive() {
        return this.activeState;
    }

    protected String getCurrentTitle() {
        if (this.current == null) {
            return "";
        }
        String result = this.current.getTitle();
        if (result.equals(this.current.getName())) {
            return "";
        }
        return String.valueOf(result) + " ";
    }

    protected void setControlSize() {
        IPartMenu partMenu;
        ArrayList<Object> topRight = new ArrayList<Object>(3);
        CTabFolder currentTop = this.tabFolder;
        String currentTitle = this.getCurrentTitle();
        if (!currentTitle.equals("")) {
            this.titleLabel.moveAbove((Control)currentTop);
            currentTop = this.titleLabel;
            topRight.add(this.titleLabel);
            this.layout.setNumLeftAligned(1);
            this.titleLabel.setText(currentTitle);
            this.titleLabel.setVisible(true);
            this.titleLabel.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT"));
        } else {
            this.titleLabel.setVisible(false);
            this.layout.setNumLeftAligned(0);
        }
        Control toolbar = this.getCurrentToolbar();
        if (toolbar != null) {
            topRight.add(toolbar);
        }
        if ((partMenu = this.getPartMenu()) != null) {
            this.viewToolBar.moveAbove((Control)currentTop);
            currentTop = this.viewToolBar;
            topRight.add(this.viewToolBar);
            this.viewToolBar.setVisible(true);
        } else {
            this.viewToolBar.setVisible(false);
        }
        Control[] controls = topRight.toArray(new Control[topRight.size()]);
        this.layout.setTopRight(controls);
        if (this.current == null || this.tabFolder == null) {
            return;
        }
        this.layout.layout();
        this.current.setBounds(this.layout.getClientBounds());
        this.updateTrimColours();
    }

    protected IPartMenu getPartMenu() {
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getMenu();
    }

    protected void updateTrimColours() {
        Color background = this.layout.isTrimOnTop() ? this.backgroundGradientEnd : this.background;
        Control[] trim = this.layout.getTopRight();
        int idx = 0;
        while (idx < trim.length) {
            Control next = trim[idx];
            Color nextCol = next.getBackground();
            if (nextCol != background) {
                next.setBackground(background);
            }
            ++idx;
        }
        this.updateBackgroundColors();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        PresentationUtil.removeDragListener((Control)this.tabFolder, this.dragListener);
        this.systemMenuManager.dispose();
        this.tabFolder.dispose();
        this.tabFolder = null;
        this.titleLabel.dispose();
        this.titleLabel = null;
        this.viewToolBar.dispose();
    }

    public void setActive(boolean isActive) {
        this.activeState = isActive;
    }

    private CTabItem createPartTab(IPresentablePart part, int tabIndex) {
        int style = 0;
        if (this.getSite().isCloseable(part)) {
            style |= 0x40;
        }
        CTabItem tabItem = new CTabItem(this.tabFolder, style, tabIndex);
        tabItem.setData(TAB_DATA, (Object)part);
        part.addPropertyListener(this.childPropertyChangeListener);
        tabItem.addDisposeListener(this.tabDisposeListener);
        this.initTab(tabItem, part);
        return tabItem;
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        tabItem.setText(part.getName());
        tabItem.setImage(part.getTitleImage());
    }

    public void addPart(IPresentablePart newPart, IPresentablePart position) {
        int idx = this.indexOf(position);
        this.createPartTab(newPart, idx);
    }

    public void removePart(IPresentablePart oldPart) {
        CTabItem item;
        if (this.current == oldPart) {
            this.current = null;
        }
        if ((item = this.getTab(oldPart)) == null) {
            return;
        }
        oldPart.setVisible(false);
        item.dispose();
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.setVisible(false);
        }
        this.current = toSelect;
        if (this.current != null) {
            this.tabFolder.setSelection(this.indexOf(this.current));
            this.setControlSize();
            this.current.setVisible(true);
        }
    }

    public IPresentablePart getCurrentPart() {
        return this.current;
    }

    public void setBounds(Rectangle bounds) {
        this.tabFolder.setBounds(bounds);
        this.setControlSize();
        this.viewToolBar.moveAbove(this.getControl());
    }

    public Point computeMinimumSize() {
        return Geometry.getSize((Rectangle)this.tabFolder.computeTrim(0, 0, 0, 0));
    }

    public void setVisible(boolean isVisible) {
        if (this.current != null) {
            this.current.setVisible(isVisible);
        }
        this.tabFolder.setVisible(isVisible);
    }

    public void setState(int state) {
        this.tabFolder.setMinimized(state == 0);
        this.tabFolder.setMaximized(state == 1);
    }

    public IMenuManager getSystemMenuManager() {
        return this.systemMenuManager;
    }

    protected void showSystemMenu(IPresentablePart part, Point point) {
        this.systemMenuManager.update(false);
        Menu aMenu = this.systemMenuManager.createContextMenu((Control)this.tabFolder.getParent());
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        Point localPos = this.tabFolder.toControl(location);
        CTabItem tabUnderPointer = this.tabFolder.getItem(localPos);
        if (tabUnderPointer == null) {
            return null;
        }
        return new StackDropResult(Geometry.toDisplay((Control)this.tabFolder, (Rectangle)tabUnderPointer.getBounds()), this.tabFolder.indexOf(tabUnderPointer));
    }

    public int getGradientPercentage() {
        int percentage;
        Rectangle clientBounds = this.getTabFolder().getBounds();
        int topTrimStart = this.getTopTrimStart();
        int n = percentage = clientBounds.width == 0 ? 100 : Math.min(100, 100 * topTrimStart / clientBounds.width);
        if (percentage < 0) {
            percentage = 0;
        }
        return percentage;
    }

    protected Control getCurrentToolbar() {
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getToolBar();
    }

    public void setBackgroundColors(Color gradientStart, Color gradientEnd, Color background) {
        this.backgroundGradientStart = gradientStart;
        this.backgroundGradientEnd = gradientEnd;
        this.background = background;
        this.updateBackgroundColors();
        this.updateTrimColours();
    }

    protected void updateBackgroundColors() {
        Color[] c;
        c = new Color[]{this.backgroundGradientStart, this.backgroundGradientEnd, c[1]};
        int[] percents = new int[]{this.getGradientPercentage(), 100};
        this.getTabFolder().setBackground(c, percents, false);
        this.getTabFolder().setBackground(this.background);
    }

    public void showSystemMenu() {
        IPresentablePart part = this.getCurrentPart();
        if (part != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.tabFolder);
            int idx = this.tabFolder.getSelectionIndex();
            if (idx > -1) {
                CTabItem item = this.tabFolder.getItem(idx);
                Rectangle itemBounds = item.getBounds();
                bounds.x += itemBounds.x;
                bounds.y += itemBounds.y;
            }
            Point location = new Point(bounds.x, bounds.y + this.tabFolder.getTabHeight());
            this.showSystemMenu(part, location);
        }
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getTabPosition() == 1024) {
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
            if (this.getTabFolder() != null) {
                list.add(this.getTabFolder());
            }
        } else {
            if (this.getTabFolder() != null) {
                list.add(this.getTabFolder());
            }
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
        }
        return list.toArray(new Control[list.size()]);
    }
}

