/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DetachedPlaceHolder;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

public class PerspectivePresentation {
    private WorkbenchPage page;
    private Composite parentWidget;
    private RootLayoutContainer mainLayout;
    private IWorkbenchPartReference zoomPart;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private boolean detachable = false;
    private boolean active = false;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;
    private IDragOverListener dragTarget = new IDragOverListener(){

        public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
            if (!(draggedObject instanceof ViewPane) && !(draggedObject instanceof PartTabFolder)) {
                return null;
            }
            LayoutPart part = (LayoutPart)draggedObject;
            if (part.getWorkbenchWindow() != PerspectivePresentation.this.page.getWorkbenchWindow()) {
                return null;
            }
            return new AbstractDropTarget(this, part, dragRectangle){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ LayoutPart val$part;
                private final /* synthetic */ Rectangle val$dragRectangle;
                {
                    this.this$1 = var1_1;
                    this.val$part = layoutPart;
                    this.val$dragRectangle = rectangle;
                }

                public void drop() {
                    Window window = this.val$part.getWindow();
                    if (window instanceof DetachedWindow) {
                        if (this.val$part instanceof PartTabFolder) {
                            window.getShell().setLocation(this.val$dragRectangle.x, this.val$dragRectangle.y);
                            return;
                        }
                        ILayoutContainer container = this.val$part.getContainer();
                        if (container instanceof PartTabFolder && ((PartTabFolder)container).getItemCount() == 1) {
                            window.getShell().setLocation(this.val$dragRectangle.x, this.val$dragRectangle.y);
                            return;
                        }
                    }
                    if (1.access$0(this.this$1).isZoomed()) {
                        1.access$0(this.this$1).zoomOut();
                    }
                    PerspectivePresentation.access$1(1.access$0(this.this$1), this.val$part, this.val$dragRectangle.x, this.val$dragRectangle.y);
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(6);
                }
            };
        }

        static /* synthetic */ PerspectivePresentation access$0(1 var0) {
            return var0.PerspectivePresentation.this;
        }
    };

    public PerspectivePresentation(WorkbenchPage workbenchPage, RootLayoutContainer mainLayout) {
        this.page = workbenchPage;
        this.mainLayout = mainLayout;
        this.detachable = false;
        Composite client = workbenchPage.getClientComposite();
        if (client != null) {
            Composite testChild = new Composite(client, 0);
            this.detachable = testChild.isReparentable();
            testChild.dispose();
        }
    }

    public void activate(Composite parent) {
        if (this.active) {
            return;
        }
        this.parentWidget = parent;
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.createControl(parent);
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow dwindow = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            dwindow.open();
            ++i;
        }
        this.enableAllDrag();
        this.active = true;
    }

    public void addPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        LayoutPart placeholder = null;
        LayoutPart testPart = this.findPart(part.getID());
        if (testPart != null && testPart instanceof PartPlaceholder) {
            placeholder = (PartPlaceholder)testPart;
        }
        if (placeholder == null) {
            part.reparent(this.mainLayout.getParent());
            LayoutPart relative = this.mainLayout.findBottomRight();
            if (relative != null && !(relative instanceof EditorArea)) {
                this.mainLayout.stack(part, relative);
            } else {
                this.mainLayout.add(part);
            }
        } else {
            ILayoutContainer container = placeholder.getContainer();
            if (container != null) {
                if (container instanceof DetachedPlaceHolder) {
                    DetachedPlaceHolder holder = (DetachedPlaceHolder)container;
                    this.detachedPlaceHolderList.remove(holder);
                    container.remove(testPart);
                    DetachedWindow window = new DetachedWindow(this.page);
                    this.detachedWindowList.add(window);
                    window.create();
                    part.createControl((Composite)window.getShell());
                    window.getShell().setBounds(holder.getBounds());
                    window.open();
                    ViewPane pane = (ViewPane)part;
                    window.getShell().setText(pane.getPartReference().getTitle());
                    window.add(pane);
                    LayoutPart[] otherChildren = holder.getChildren();
                    int i = 0;
                    while (i < otherChildren.length) {
                        part.getContainer().add(otherChildren[i]);
                        ++i;
                    }
                } else {
                    if (container instanceof ContainerPlaceholder) {
                        ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                        ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                        container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                        if (container instanceof LayoutPart) {
                            parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                        }
                        containerPlaceholder.setRealContainer(null);
                    }
                    if (container instanceof PartTabFolder) {
                        PartTabFolder folder = (PartTabFolder)container;
                        part.reparent(folder.getControl().getParent());
                    } else {
                        part.reparent(this.mainLayout.getParent());
                    }
                    container.replace(placeholder, part);
                }
            }
        }
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart part) {
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            int nIndex = folder.indexOf(part);
            if (folder.getSelection() != nIndex) {
                folder.setSelection(nIndex);
                return true;
            }
        }
        return false;
    }

    public boolean isPartVisible(String partId) {
        LayoutPart part = this.findPart(partId);
        if (part == null) {
            return false;
        }
        if (part instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            return false;
        }
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getID().equals(folder.getVisiblePart().getID());
        }
        return true;
    }

    public boolean willPartBeVisible(String partId) {
        LayoutPart part = this.findPart(partId);
        if (part == null) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            container = (ILayoutContainer)((Object)((ContainerPlaceholder)container).getRealContainer());
        }
        if (container != null && container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getID().equals(folder.getVisiblePart().getID());
        }
        return true;
    }

    public void openTracker(ViewPane pane) {
        DragUtil.performDrag(pane, DragUtil.getDisplayBounds(pane.getControl()));
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] results = this.collectPlaceholders(this.mainLayout.getChildren());
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                PartPlaceholder[] moreResults = this.collectPlaceholders(win.getChildren());
                if (moreResults.length > 0) {
                    int newLength = results.length + moreResults.length;
                    PartPlaceholder[] newResults = new PartPlaceholder[newLength];
                    System.arraycopy(results, 0, newResults, 0, results.length);
                    System.arraycopy(moreResults, 0, newResults, results.length, moreResults.length);
                    results = newResults;
                }
                ++i;
            }
        }
        return results;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] parts) {
        PartPlaceholder[] result = new PartPlaceholder[]{};
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer) {
                PartPlaceholder[] newParts = this.collectPlaceholders(((ILayoutContainer)((Object)part)).getChildren());
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + newParts.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(newParts, 0, newResult, result.length, newParts.length);
                result = newResult;
            } else if (part instanceof PartPlaceholder) {
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = (PartPlaceholder)part;
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public void collectViewPanes(List result) {
        this.collectViewPanes(result, this.mainLayout.getChildren());
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                this.collectViewPanes(result, win.getChildren());
                ++i;
            }
        }
    }

    private void collectViewPanes(List result, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
            } else if (part instanceof ILayoutContainer) {
                this.collectViewPanes(result, ((ILayoutContainer)((Object)part)).getChildren());
            }
            ++i;
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite parent = this.mainLayout.getParent();
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            this.collectViewPanes(children, window.getChildren());
            ++i;
        }
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.dispose();
        int i2 = 0;
        int length2 = this.detachedWindowList.size();
        while (i2 < length2) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i2));
            window.close();
            ++i2;
        }
        this.active = false;
    }

    void derefPart(LayoutPart part) {
        if (part instanceof ViewPane) {
            this.page.removeFastView(((ViewPane)part).getViewReference());
        }
        Window oldWindow = part.getWindow();
        ILayoutContainer oldContainer = part.getContainer();
        part.reparent(this.mainLayout.getParent());
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        LayoutPart[] children = oldContainer.getChildren();
        if (oldWindow instanceof WorkbenchWindow) {
            LayoutPart parent;
            ILayoutContainer parentContainer;
            boolean hasChildren;
            boolean bl = hasChildren = children != null && children.length > 0;
            if (hasChildren) {
                int childVisible = 0;
                int i = 0;
                while (i < children.length) {
                    if (children[i].getControl() != null) {
                        ++childVisible;
                    }
                    ++i;
                }
                if (oldContainer instanceof PartTabFolder) {
                    PartTabFolder folder = (PartTabFolder)oldContainer;
                    if (childVisible == 0) {
                        ILayoutContainer parentContainer2 = folder.getContainer();
                        int i2 = 0;
                        while (i2 < children.length) {
                            folder.remove(children[i2]);
                            parentContainer2.add(children[i2]);
                            ++i2;
                        }
                        hasChildren = false;
                    } else if (childVisible == 1) {
                        LayoutTree layout = this.mainLayout.getLayoutTree();
                        layout = layout.find(folder);
                        layout.setBounds(layout.getBounds());
                    }
                }
            }
            if (!hasChildren && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
                parentContainer.remove(parent);
                parent.dispose();
            }
        } else if (oldWindow instanceof DetachedWindow) {
            if (children == null || children.length == 0) {
                oldWindow.getShell().setRedraw(true);
                oldWindow.close();
                this.detachedWindowList.remove(oldWindow);
            } else {
                boolean allInvisible = true;
                int i = 0;
                int length = children.length;
                while (i < length) {
                    if (!(children[i] instanceof PartPlaceholder)) {
                        allInvisible = false;
                        break;
                    }
                    ++i;
                }
                if (allInvisible) {
                    DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                    int i3 = 0;
                    int length2 = children.length;
                    while (i3 < length2) {
                        oldContainer.remove(children[i3]);
                        children[i3].setContainer(placeholder);
                        placeholder.add(children[i3]);
                        ++i3;
                    }
                    this.detachedPlaceHolderList.add(placeholder);
                    oldWindow.close();
                    this.detachedWindowList.remove(oldWindow);
                }
            }
        }
    }

    private void detach(LayoutPart source, int x, int y) {
        ILayoutContainer container;
        if (!this.detachable) {
            return;
        }
        LayoutPart part = source.getPart();
        Point size = part.getSize();
        if ((size.x == 0 || size.y == 0) && (container = part.getContainer()) instanceof LayoutPart) {
            size = ((LayoutPart)((Object)container)).getSize();
        }
        int width = Math.max(size.x, 150);
        int height = Math.max(size.y, 250);
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        window.getShell().setBounds(x, y, width, height);
        window.open();
        if (part instanceof PartTabFolder) {
            window.getShell().setRedraw(false);
            this.parentWidget.setRedraw(false);
            LayoutPart visiblePart = ((PartTabFolder)part).getVisiblePart();
            LayoutPart[] children = ((PartTabFolder)part).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ViewPane) {
                    this.derefPart(children[i]);
                    ViewPane pane = (ViewPane)children[i];
                    window.getShell().setText(pane.getPartReference().getTitle());
                    window.add(pane);
                }
                ++i;
            }
            if (visiblePart != null) {
                this.bringPartToTop(visiblePart);
                visiblePart.setFocus();
            }
            window.getShell().setRedraw(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.derefPart(part);
            ViewPane pane = (ViewPane)part;
            window.getShell().setText(pane.getPartReference().getTitle());
            window.add(pane);
            part.setFocus();
        }
    }

    public void addDetachedPart(LayoutPart part) {
        if (!this.detachable) {
            this.addPart(part);
            return;
        }
        int width = 300;
        int height = 300;
        Rectangle bounds = this.parentWidget.getShell().getBounds();
        int x = bounds.x + (bounds.width - width) / 2;
        int y = bounds.y + (bounds.height - height) / 2;
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        part.createControl((Composite)window.getShell());
        ViewPane pane = (ViewPane)part;
        window.getShell().setText(pane.getPartReference().getTitle());
        window.add(pane);
        window.getShell().setBounds(x, y, width, height);
        window.open();
        part.setFocus();
    }

    private void disableAllDrag() {
        DragUtil.removeDragTarget(null, this.dragTarget);
    }

    public void disposeSashes() {
        this.mainLayout.disposeSashes();
    }

    private void enableAllDrag() {
        DragUtil.addDragTarget(null, this.dragTarget);
    }

    private LayoutPart findPart(String id) {
        LayoutPart part = this.findPart(id, this.mainLayout.getChildren());
        if (part != null) {
            return part;
        }
        int i = 0;
        int length = this.detachedWindowList.size();
        while (i < length) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            part = this.findPart(id, window.getChildren());
            if (part != null) {
                return part;
            }
            ++i;
        }
        i = 0;
        while (i < this.detachedPlaceHolderList.size()) {
            DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
            part = this.findPart(id, holder.getChildren());
            if (part != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private LayoutPart findPart(String id, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part.getID().equals(id)) {
                return part;
            }
            if (!(part instanceof EditorArea) && part instanceof ILayoutContainer && (part = this.findPart(id, ((ILayoutContainer)((Object)part)).getChildren())) != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public boolean hasPlaceholder(String id) {
        LayoutPart testPart = this.findPart(id);
        return testPart != null && testPart instanceof PartPlaceholder;
    }

    public RootLayoutContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isFastView(IWorkbenchPartReference ref) {
        if (ref instanceof IViewReference) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            return page.isFastView((IViewReference)ref);
        }
        return false;
    }

    public boolean isZoomed() {
        return this.zoomPart != null;
    }

    private void makeFast(LayoutPart source) {
        LayoutPart part = source.getPart();
        if (part instanceof PartTabFolder) {
            LayoutPart[] children = ((PartTabFolder)part).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ViewPane) {
                    this.page.addFastView(((ViewPane)children[i]).getViewReference());
                }
                ++i;
            }
        } else {
            this.page.addFastView(((ViewPane)part).getViewReference());
        }
    }

    public static float getDockingRatio(LayoutPart source, LayoutPart target) {
        if ((source instanceof ViewPane || source instanceof PartTabFolder) && target instanceof EditorArea) {
            return 0.25f;
        }
        return 0.5f;
    }

    public boolean partChangeAffectsZoom(PartPane pane) {
        if (this.zoomPart == null) {
            return false;
        }
        if (pane.getWindow().getShell() != this.page.getWorkbenchWindow().getShell()) {
            return false;
        }
        if (pane.isZoomed()) {
            return false;
        }
        if (this.isFastView(pane.getPartReference())) {
            return false;
        }
        PartPane zoomPane = ((WorkbenchPartReference)this.zoomPart).getPane();
        return !(pane instanceof EditorPane) || !(zoomPane instanceof EditorPane) || !((EditorPane)pane).getWorkbook().equals(((EditorPane)zoomPane).getWorkbook());
    }

    public void removePart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        Composite parent = this.mainLayout.getParent();
        part.reparent(parent);
        ILayoutContainer container = part.getContainer();
        if (container != null) {
            container.replace(part, new PartPlaceholder(part.getID()));
            if (container == this.mainLayout) {
                return;
            }
            LayoutPart[] children = container.getChildren();
            if (children != null) {
                boolean allInvisible = true;
                int i = 0;
                int length = children.length;
                while (i < length) {
                    if (!(children[i] instanceof PartPlaceholder)) {
                        allInvisible = false;
                        break;
                    }
                    ++i;
                }
                if (allInvisible && container instanceof LayoutPart) {
                    LayoutPart cPart = (LayoutPart)((Object)container);
                    Window oldWindow = cPart.getWindow();
                    if (oldWindow instanceof WorkbenchWindow) {
                        if (container instanceof PartTabFolder) {
                            ((PartTabFolder)container).dispose();
                        }
                        ILayoutContainer parentContainer = cPart.getContainer();
                        ContainerPlaceholder placeholder = new ContainerPlaceholder(cPart.getID());
                        placeholder.setRealContainer(container);
                        parentContainer.replace(cPart, placeholder);
                    } else if (oldWindow instanceof DetachedWindow) {
                        DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                        int i2 = 0;
                        int length2 = children.length;
                        while (i2 < length2) {
                            children[i2].getContainer().remove(children[i2]);
                            children[i2].setContainer(placeholder);
                            placeholder.add(children[i2]);
                            ++i2;
                        }
                        this.detachedPlaceHolderList.add(placeholder);
                        oldWindow.close();
                        this.detachedWindowList.remove(oldWindow);
                    }
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        PartPlaceholder[] placeholders = this.collectPlaceholders();
        int i = 0;
        int length = placeholders.length;
        while (i < length) {
            ILayoutContainer container;
            if (placeholders[i].getID().equals(part.getID()) && (container = placeholders[i].getContainer()) != null) {
                if (container instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                    ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                    container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (container instanceof LayoutPart) {
                        parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                container.replace(placeholders[i], part);
                return;
            }
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento childMem = memento.getChild("mainWindow");
        IStatus r = this.mainLayout.restoreState(childMem);
        if (this.detachable) {
            IMemento[] detachedWindows = memento.getChildren("detachedWindow");
            int nX = 0;
            while (nX < detachedWindows.length) {
                DetachedWindow win = new DetachedWindow(this.page);
                this.detachedWindowList.add(win);
                win.restoreState(detachedWindows[nX]);
                ++nX;
            }
            IMemento[] childrenMem = memento.getChildren("hiddenWindow");
            int i = 0;
            int length = childrenMem.length;
            while (i < length) {
                DetachedPlaceHolder holder = new DetachedPlaceHolder("", new Rectangle(0, 0, 0, 0));
                holder.restoreState(childrenMem[i]);
                this.detachedPlaceHolderList.add(holder);
                ++i;
            }
        }
        return r;
    }

    public IStatus saveState(IMemento memento) {
        IMemento childMem = memento.createChild("mainWindow");
        IStatus r = this.mainLayout.saveState(childMem);
        if (this.detachable) {
            int i = 0;
            int length = this.detachedWindowList.size();
            while (i < length) {
                DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                childMem = memento.createChild("detachedWindow");
                window.saveState(childMem);
                ++i;
            }
            i = 0;
            length = this.detachedPlaceHolderList.size();
            while (i < length) {
                DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
                childMem = memento.createChild("hiddenWindow");
                holder.saveState(childMem);
                ++i;
            }
        }
        return r;
    }

    public void zoomIn(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        this.zoomPart = ref;
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            ILayoutContainer parentContainer = ((ViewPane)pane).getContainer();
            if (parentContainer instanceof PartTabFolder) {
                PartTabFolder parent = (PartTabFolder)parentContainer;
                Perspective persp = this.page.getActivePerspective();
                if (persp != null && ref instanceof IViewReference && this.page.isFastView((IViewReference)ref)) {
                    persp.hideFastViewSash();
                }
                this.mainLayout.zoomIn(parent);
                pane.setZoomed(true);
                this.parentWidget.setRedraw(true);
            }
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            EditorWorkbook wb = ((EditorPane)pane).getWorkbook();
            EditorArea ea = wb.getEditorArea();
            this.mainLayout.zoomIn(ea);
            ea.zoomIn(wb);
            wb.setZoomed(true);
            pane.setZoomed(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.zoomPart = null;
            return;
        }
    }

    public void zoomOut() {
        if (this.zoomPart == null) {
            return;
        }
        PartPane pane = ((WorkbenchPartReference)this.zoomPart).getPane();
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            Perspective persp = this.page.getActivePerspective();
            if (persp != null && this.zoomPart instanceof IViewReference && this.page.isFastView((IViewReference)this.zoomPart)) {
                persp.showFastView((IViewReference)this.zoomPart);
            }
            this.parentWidget.setRedraw(true);
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            EditorWorkbook wb = ((EditorPane)pane).getWorkbook();
            EditorArea ea = wb.getEditorArea();
            wb.setZoomed(false);
            ea.zoomOut();
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            this.parentWidget.setRedraw(true);
        } else {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            this.parentWidget.setRedraw(true);
        }
        this.zoomPart = null;
    }

    static /* synthetic */ void access$1(PerspectivePresentation perspectivePresentation, LayoutPart layoutPart, int n, int n2) {
        perspectivePresentation.detach(layoutPart, n, n2);
    }
}

