/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchPlugin;

class ActivityPersistanceHelper {
    private static String PREFIX = "UIActivities.";
    private static ActivityPersistanceHelper singleton;

    public static ActivityPersistanceHelper getInstance() {
        if (singleton == null) {
            singleton = new ActivityPersistanceHelper();
        }
        return singleton;
    }

    private ActivityPersistanceHelper() {
        this.loadEnabledStates();
    }

    private String createPreferenceKey(String activityId) {
        return String.valueOf(PREFIX) + activityId;
    }

    void loadEnabledStates() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = support.getActivityManager();
        Iterator i = activityManager.getEnabledActivityIds().iterator();
        while (i.hasNext()) {
            store.setDefault(this.createPreferenceKey((String)i.next()), true);
        }
        HashSet<String> enabledActivities = new HashSet<String>();
        Iterator i2 = activityManager.getDefinedActivityIds().iterator();
        while (i2.hasNext()) {
            String activityId = (String)i2.next();
            if (!store.getBoolean(this.createPreferenceKey(activityId))) continue;
            enabledActivities.add(activityId);
        }
        support.setEnabledActivityIds(enabledActivities);
    }

    private void saveEnabledStates() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = support.getActivityManager();
        Iterator values = activityManager.getDefinedActivityIds().iterator();
        while (values.hasNext()) {
            IActivity activity = activityManager.getActivity((String)values.next());
            store.setValue(this.createPreferenceKey(activity.getId()), activity.isEnabled());
        }
    }

    public void shutdown() {
        this.saveEnabledStates();
    }
}

