/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    String computeResult() {
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove((GtkFileSelection)selection, (int)this.handle);
        int entry = selection.selection_entry;
        int entryText = OS.gtk_entry_get_text((int)entry);
        int entryLength = OS.strlen((int)entryText);
        if (entryLength == 0) {
            int[] model;
            int fileList = selection.file_list;
            int listSelection = OS.gtk_tree_view_get_selection((int)fileList);
            int selectedList = OS.gtk_tree_selection_get_selected_rows((int)listSelection, (int[])(model = new int[1]));
            if (selectedList == 0) {
                return null;
            }
            int listLength = OS.g_list_length((int)selectedList);
            if (listLength == 0) {
                OS.g_list_free((int)selectedList);
                return null;
            }
            int path = OS.g_list_nth_data((int)selectedList, (int)0);
            int[] ptr = new int[1];
            int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter((int)model[0], (int)iter, (int)path)) {
                OS.gtk_tree_model_get((int)model[0], (int)iter, (int)0, (int[])ptr, (int)-1);
            }
            OS.g_free((int)iter);
            int i = 0;
            while (i < listLength) {
                OS.gtk_tree_path_free((int)OS.g_list_nth_data((int)selectedList, (int)i));
                ++i;
            }
            OS.g_list_free((int)selectedList);
            if (ptr[0] == 0) {
                return null;
            }
            int length = OS.strlen((int)ptr[0]);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)ptr[0], (int)length);
            OS.g_free((int)ptr[0]);
            OS.gtk_entry_set_text((int)entry, (byte[])buffer);
        }
        int fileNamePtr = OS.gtk_file_selection_get_filename((int)this.handle);
        int utf8Ptr = OS.g_filename_to_utf8((int)fileNamePtr, (int)-1, null, null, null);
        int[] items_written = new int[1];
        int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
        entryLength = items_written[0];
        char[] buffer = new char[entryLength];
        OS.memmove((char[])buffer, (int)utf16Ptr, (int)(entryLength * 2));
        String osAnswer = new String(buffer);
        OS.g_free((int)utf16Ptr);
        OS.g_free((int)utf8Ptr);
        if (osAnswer == null) {
            return null;
        }
        int separatorIndex = osAnswer.lastIndexOf(SEPARATOR);
        if (separatorIndex + 1 == osAnswer.length()) {
            return null;
        }
        String answer = this.fullPath = osAnswer;
        this.fileName = this.fullPath.substring(separatorIndex + 1);
        this.filterPath = this.fullPath.substring(0, separatorIndex);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            int namesPtr;
            int namesPtr1 = namesPtr = OS.gtk_file_selection_get_selections((int)this.handle);
            int[] namePtr = new int[1];
            OS.memmove((int[])namePtr, (int)namesPtr1, (int)OS.PTR_SIZEOF);
            int length = 0;
            while (namePtr[0] != 0) {
                ++length;
                OS.memmove((int[])namePtr, (int)(namesPtr1 += OS.PTR_SIZEOF), (int)OS.PTR_SIZEOF);
            }
            this.fileNames = new String[length];
            namePtr = new int[length];
            OS.memmove((int[])namePtr, (int)namesPtr, (int)(length * OS.PTR_SIZEOF));
            int i = 0;
            while (i < length) {
                utf8Ptr = OS.g_filename_to_utf8((int)namePtr[i], (int)-1, null, null, null);
                items_written = new int[1];
                utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
                buffer = new char[items_written[0]];
                OS.memmove((char[])buffer, (int)utf16Ptr, (int)(items_written[0] * 2));
                String name = new String(buffer);
                this.fileNames[i] = name.substring(name.lastIndexOf(SEPARATOR) + 1);
                OS.g_free((int)utf16Ptr);
                OS.g_free((int)utf8Ptr);
                ++i;
            }
            OS.g_strfreev((int)namesPtr);
        }
        return answer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new((byte[])titleBytes);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)this.handle, (int)this.parent.topHandle());
        }
        String answer = null;
        this.preset();
        int response = OS.gtk_dialog_run((int)this.handle);
        if (response == -5) {
            answer = this.computeResult();
        }
        OS.gtk_widget_destroy((int)this.handle);
        return answer;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    void preset() {
        OS.gtk_file_selection_set_select_multiple((int)this.handle, ((this.style & 2) != 0 ? 1 : 0) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int length = this.fullPath.length();
        char[] buffer = new char[length + 1];
        this.fullPath.getChars(0, length, buffer, 0);
        int utf8Ptr = OS.g_utf16_to_utf8((char[])buffer, (int)-1, null, null, null);
        int fileNamePtr = OS.g_filename_from_utf8((int)utf8Ptr, (int)-1, null, null, null);
        OS.gtk_file_selection_set_filename((int)this.handle, (int)fileNamePtr);
        OS.g_free((int)utf8Ptr);
        OS.g_free((int)fileNamePtr);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterExtensions.length == 1) {
            String ext = this.filterExtensions[0];
            byte[] extBytes = Converter.wcsToMbcs(null, ext, true);
            OS.gtk_file_selection_complete((int)this.handle, (byte[])extBytes);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }
}

