/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import swingwt.awt.Component;
import swingwtx.swing.JMenuBar;
import swingwtx.swing.JSWTMenuComponent;
import swingwtx.swing.event.PopupMenuEvent;
import swingwtx.swing.event.PopupMenuListener;

public class JPopupMenu
extends JMenuBar {
    protected Vector popupListeners = new Vector();
    protected static final int CANCELED = 0;
    protected static final int INVISIBLE = 1;
    protected static final int VISIBLE = 2;

    public JPopupMenu() {
    }

    public JPopupMenu(String label) {
    }

    protected JPopupMenu(Vector childComponents) {
        this.components = childComponents;
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.popupListeners.add(l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.popupListeners.remove(l);
    }

    public void processPopupMenuEvent(int id) {
        Iterator i = this.popupListeners.iterator();
        PopupMenuEvent e = new PopupMenuEvent(this);
        while (i.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)i.next();
            switch (id) {
                case 0: {
                    l.popupMenuCanceled(e);
                    break;
                }
                case 1: {
                    l.popupMenuWillBecomeInvisible(e);
                    break;
                }
                case 2: {
                    l.popupMenuWillBecomeVisible(e);
                }
            }
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.processPopupMenuEvent(2);
        } else {
            this.processPopupMenuEvent(1);
            this.processPopupMenuEvent(0);
        }
    }

    public void show(Component c, int x, int y) {
        boolean needToCreatePeer;
        boolean bl = needToCreatePeer = this.menu == null;
        if (!needToCreatePeer) {
            needToCreatePeer = this.menu.isDisposed();
        }
        if (needToCreatePeer) {
            this.setSwingWTParent(c.getSWTPeer().getShell());
            c.getSWTPeer().setMenu(this.menu);
        }
        this.menu.setVisible(true);
    }

    public void setSwingWTParent(Shell parent) {
        this.shell = parent;
        this.menu = new Menu((Decorations)parent, 8);
        if (this.components.size() > 0) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                this.add((JSWTMenuComponent)i.next());
            }
        }
        this.menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent arg0) {
                JPopupMenu.this.processPopupMenuEvent(1);
                JPopupMenu.this.processPopupMenuEvent(0);
            }

            public void menuShown(MenuEvent arg0) {
                JPopupMenu.this.processPopupMenuEvent(2);
            }
        });
    }
}

