/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.EventObject;
import swingwt.awt.Component;
import swingwt.awt.event.FocusEvent;
import swingwt.awt.event.FocusListener;
import swingwt.awt.event.MouseEvent;
import swingwtx.swing.AbstractCellEditor;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JComboBox;
import swingwtx.swing.JComponent;
import swingwtx.swing.JTable;
import swingwtx.swing.JTextField;
import swingwtx.swing.JTree;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;
import swingwtx.swing.table.TableCellEditor;
import swingwtx.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected JComponent editorComponent;
    protected int clickCountToStart = 1;
    protected SWTEditor handler = null;

    public DefaultCellEditor(final JTextField textField) {
        this.editorComponent = textField;
        this.clickCountToStart = 2;
        this.handler = new SWTEditor(){

            public void setValue(Object value) {
                textField.setText(value != null ? value.toString() : "");
            }

            public Object getCellEditorValue() {
                return textField.getText();
            }
        };
        textField.addFocusListener(this.handler);
    }

    public DefaultCellEditor(final JCheckBox checkBox) {
        this.editorComponent = checkBox;
        this.handler = new SWTEditor(){

            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                checkBox.setSelected(selected);
            }

            public Object getCellEditorValue() {
                return new Boolean(checkBox.isSelected());
            }
        };
        checkBox.addFocusListener(this.handler);
    }

    public DefaultCellEditor(final JComboBox comboBox) {
        this.editorComponent = comboBox;
        this.handler = new SWTEditor(){

            public void setValue(Object value) {
                comboBox.setSelectedItem(value);
            }

            public Object getCellEditorValue() {
                return comboBox.getSelectedItem();
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            public boolean stopCellEditing() {
                return super.stopCellEditing();
            }
        };
        comboBox.addChangeListener(this.handler);
    }

    public SWTEditor getHandler() {
        return this.handler;
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.handler.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.handler.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.handler.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        return this.handler.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.handler.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.handler.setValue(value);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.handler.setValue(value);
        return this.editorComponent;
    }

    protected abstract class SWTEditor
    implements FocusListener,
    ChangeListener {
        protected SWTEditor() {
        }

        public abstract Object getCellEditorValue();

        public abstract void setValue(Object var1);

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= DefaultCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            DefaultCellEditor.this.fireEditingStopped();
            DefaultCellEditor.this.editorComponent.getSWTPeer().dispose();
            return true;
        }

        public void cancelCellEditing() {
            DefaultCellEditor.this.fireEditingCanceled();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.stopCellEditing();
        }

        public void stateChanged(ChangeEvent e) {
            this.stopCellEditing();
        }
    }
}

