/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Color;
import swingwt.awt.Font;
import swingwtx.swing.Icon;
import swingwtx.swing.border.BevelBorder;
import swingwtx.swing.border.Border;
import swingwtx.swing.border.CompoundBorder;
import swingwtx.swing.border.EmptyBorder;
import swingwtx.swing.border.EtchedBorder;
import swingwtx.swing.border.LineBorder;
import swingwtx.swing.border.MatteBorder;
import swingwtx.swing.border.TitledBorder;

public abstract class BorderFactory {
    static final Border sharedRaisedBevel = new BevelBorder(0);
    static final Border sharedLoweredBevel = new BevelBorder(1);
    static final Border sharedEtchedBorder = new EtchedBorder();
    private static Border sharedRaisedEtchedBorder;
    static final Border emptyBorder;

    public static Border createLineBorder(Color color) {
        return new LineBorder(color, 1);
    }

    public static Border createLineBorder(Color color, int thickness) {
        return new LineBorder(color, thickness);
    }

    public static Border createRaisedBevelBorder() {
        return BorderFactory.createSharedBevel(0);
    }

    public static Border createLoweredBevelBorder() {
        return BorderFactory.createSharedBevel(1);
    }

    public static Border createBevelBorder(int type) {
        return BorderFactory.createSharedBevel(type);
    }

    public static Border createBevelBorder(int type, Color highlight, Color shadow) {
        return new BevelBorder(type, highlight, shadow);
    }

    public static Border createBevelBorder(int type, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        return new BevelBorder(type, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    static Border createSharedBevel(int type) {
        if (type == 0) {
            return sharedRaisedBevel;
        }
        if (type == 1) {
            return sharedLoweredBevel;
        }
        return null;
    }

    public static Border createEtchedBorder() {
        return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(Color highlight, Color shadow) {
        return new EtchedBorder(highlight, shadow);
    }

    public static Border createEtchedBorder(int type) {
        switch (type) {
            case 0: {
                if (sharedRaisedEtchedBorder == null) {
                    sharedRaisedEtchedBorder = new EtchedBorder(0);
                }
                return sharedRaisedEtchedBorder;
            }
            case 1: {
                return sharedEtchedBorder;
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public static Border createEtchedBorder(int type, Color highlight, Color shadow) {
        return new EtchedBorder(type, highlight, shadow);
    }

    public static TitledBorder createTitledBorder(String title) {
        return new TitledBorder(title);
    }

    public static TitledBorder createTitledBorder(Border border) {
        return new TitledBorder(border);
    }

    public static TitledBorder createTitledBorder(Border border, String title) {
        return new TitledBorder(border, title);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        return new TitledBorder(border, title, titleJustification, titlePosition);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        return new TitledBorder(border, title, titleJustification, titlePosition, titleFont);
    }

    public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        return new TitledBorder(border, title, titleJustification, titlePosition, titleFont, titleColor);
    }

    public static Border createEmptyBorder() {
        return emptyBorder;
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(top, left, bottom, right);
    }

    public static CompoundBorder createCompoundBorder() {
        return new CompoundBorder();
    }

    public static CompoundBorder createCompoundBorder(Border outsideBorder, Border insideBorder) {
        return new CompoundBorder(outsideBorder, insideBorder);
    }

    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, Color color) {
        return new MatteBorder(top, left, bottom, right, color);
    }

    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, Icon tileIcon) {
        return new MatteBorder(top, left, bottom, right, tileIcon);
    }

    static {
        emptyBorder = new EmptyBorder(0, 0, 0, 0);
    }
}

