/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.custom;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Image;
import swingwtx.custom.event.TabCloseListener;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.TabItemCache;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class JClosableTabbedPane
extends JComponent
implements SwingConstants {
    protected CTabFolder ppeer = null;
    protected Vector tabs = new Vector();
    protected Vector tabCloseListeners = new Vector();
    protected int pTabPlacement = 1;
    protected Vector changeListeners = new Vector();
    protected int pSelectedIndex = -1;
    private int iRetVal = 0;
    private String sRetVal = "";
    private Object retval;

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, null, component);
    }

    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null, true);
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        this.addTab(title, icon, component, tip, true);
    }

    public void addTab(String title, Icon icon, Component component, String tip, boolean enabled) {
        this.addTab(title, icon, component, tip, enabled, false);
    }

    public void addTab(final String title, final Icon icon, final Component component, final String tip, final boolean enabled, boolean fromcache) {
        if (!fromcache) {
            TabItemCache t = new TabItemCache();
            t.title = title;
            t.icon = icon;
            t.component = component;
            t.tip = tip;
            t.enabled = enabled;
            this.tabs.add(t);
            t = null;
        }
        final JClosableTabbedPane me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JClosableTabbedPane.this.ppeer)) {
                    return;
                }
                CTabItem t = new CTabItem(JClosableTabbedPane.this.ppeer, 0);
                try {
                    component.setSwingWTParent(me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (title != null) {
                    t.setText(title);
                }
                if (icon != null) {
                    t.setImage(SwingWTUtils.getSWTImageFromSwingIcon(me, icon));
                }
                if (component != null && enabled) {
                    t.setControl(component.getSWTPeer());
                }
                if (tip != null) {
                    t.setToolTipText(tip);
                }
                t.setData("enabled", (Object)(enabled ? "true" : "false"));
                JClosableTabbedPane.this.postponeLayout();
            }
        });
    }

    public Icon getIconAt(final int index) {
        if (this.ppeer == null) {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            return t.icon;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Image image = new Image();
                image.image = JClosableTabbedPane.this.ppeer.getItem(index).getImage();
                JClosableTabbedPane.this.retval = new ImageIcon(image);
            }
        });
        return (Icon)this.retval;
    }

    public void setIconAt(final int index, final Icon icon) {
        TabItemCache t = (TabItemCache)this.tabs.get(index);
        t.icon = icon;
        final JClosableTabbedPane pthis = this;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.ppeer.getItem(index).setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, icon));
                }
            });
        }
    }

    public void addTabCloseListener(TabCloseListener l) {
        this.tabCloseListeners.add(l);
    }

    public void removeTabCloseListener(TabCloseListener l) {
        this.tabCloseListeners.remove(l);
    }

    public void setEnabledAt(final int index, final boolean b) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.ppeer.getItem(index).setData("enabled", (Object)(b ? "true" : "false"));
                    if (!b) {
                        JClosableTabbedPane.this.ppeer.getItem(index).setControl(null);
                    } else {
                        JClosableTabbedPane.this.ppeer.getItem(index).setControl(((TabItemCache)JClosableTabbedPane.this.tabs.get((int)index)).component.getSWTPeer());
                    }
                }
            });
        } else {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.enabled = b;
        }
    }

    public int getTabCount() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.tabs.size();
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JClosableTabbedPane.this.iRetVal = JClosableTabbedPane.this.ppeer.getItemCount();
            }
        });
        return this.iRetVal;
    }

    public int getSelectedIndex() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.iRetVal = JClosableTabbedPane.this.ppeer.getSelectionIndex();
                }
            });
        } else {
            this.iRetVal = -1;
        }
        return this.iRetVal;
    }

    public Component getSelectedComponent() {
        int i = this.getSelectedIndex();
        if (i != -1) {
            return ((TabItemCache)this.tabs.get((int)i)).component;
        }
        return null;
    }

    public void setSelectedIndex(final int index) {
        this.pSelectedIndex = index;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.ppeer.setSelection(index);
                }
            });
        }
    }

    public void removeTabAt(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.tabs.removeElementAt(index);
                    JClosableTabbedPane.this.ppeer.getItem(index).dispose();
                }
            });
        } else {
            this.tabs.removeElementAt(index);
        }
    }

    public String getTitleAt(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.sRetVal = JClosableTabbedPane.this.ppeer.getItem(index).getText();
                }
            });
            return this.sRetVal;
        }
        TabItemCache t = (TabItemCache)this.tabs.get(index);
        return t.title;
    }

    public void setTitleAt(final int index, final String title) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JClosableTabbedPane.this.ppeer.getItem(index).setText(title);
                }
            });
        } else {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.title = title;
        }
    }

    public int getTabPlacement() {
        return this.pTabPlacement;
    }

    public void setTabPlacement(int place) {
        this.pTabPlacement = place;
    }

    public Control getSWTPeer() {
        return this.ppeer;
    }

    protected void processTabClosing(CTabFolderEvent e) {
        CTabItem[] items = this.ppeer.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!e.item.equals(items[i])) continue;
            Iterator iter = this.tabCloseListeners.iterator();
            while (iter.hasNext()) {
                TabCloseListener l = (TabCloseListener)iter.next();
                e.doit = l.tabClosed(i);
            }
        }
    }

    protected void processChangeEvent(ChangeEvent e) {
        Iterator i = this.changeListeners.iterator();
        while (i.hasNext()) {
            ChangeListener l = (ChangeListener)i.next();
            l.stateChanged(e);
        }
    }

    protected void postponeLayout() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JClosableTabbedPane.this.layoutTab();
            }
        });
    }

    protected void layoutTab() {
        int i = this.ppeer.getSelectionIndex();
        if (i < 0 || i >= this.ppeer.getItems().length) {
            return;
        }
        Control p = this.ppeer.getItem(this.ppeer.getSelectionIndex()).getControl();
        if (p instanceof Composite) {
            ((Composite)p).layout(true);
        } else {
            p.redraw();
        }
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new CTabFolder(parent.getComposite(), SwingWTUtils.translateSwingAlignmentConstant(this.pTabPlacement));
        this.peer = this.ppeer;
        this.composite = this.ppeer;
        this.parent = parent;
        if (this.tabs.size() > 0) {
            Object[] tabso = this.tabs.toArray();
            for (int i = 0; i < tabso.length; ++i) {
                TabItemCache t = (TabItemCache)tabso[i];
                this.addTab(t.title, t.icon, t.component, t.tip, t.enabled, true);
            }
        }
        if (this.pSelectedIndex != -1) {
            this.ppeer.setSelection(this.pSelectedIndex);
        }
        this.ppeer.setUnselectedCloseVisible(true);
        this.ppeer.setUnselectedImageVisible(true);
        this.ppeer.addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

            public void itemClosed(CTabFolderEvent event) {
                JClosableTabbedPane.this.processTabClosing(event);
            }
        });
        final JClosableTabbedPane me = this;
        this.ppeer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JClosableTabbedPane.this.checkTabEnabled(e)) {
                    JClosableTabbedPane.this.postponeLayout();
                    ChangeEvent ce = new ChangeEvent(me);
                    JClosableTabbedPane.this.processChangeEvent(ce);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.ppeer.getItemCount() > 0) {
            this.postponeLayout();
        }
    }

    protected boolean checkTabEnabled(SelectionEvent e) {
        e.doit = e.item.getData("enabled").toString().equals("true");
        return e.doit;
    }
}

