/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.DemoModule;
import demo.swingset.Permuter;
import demo.swingset.SwingSet2;
import java.util.Vector;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.swing.AbstractAction;
import swingwtx.swing.AbstractListModel;
import swingwtx.swing.Action;
import swingwtx.swing.Box;
import swingwtx.swing.BoxLayout;
import swingwtx.swing.DefaultListCellRenderer;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JCheckBox;
import swingwtx.swing.JLabel;
import swingwtx.swing.JList;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.ListCellRenderer;
import swingwtx.swing.ListModel;

public class ListDemo
extends DemoModule {
    JList list;
    JPanel prefixList;
    JPanel suffixList;
    Action prefixAction;
    Action suffixAction;
    GeneratedListModel listModel;
    Vector checkboxes = new Vector();
    ImageIcon[] images = new ImageIcon[7];

    public static void main(String[] stringArray) {
        ListDemo listDemo = new ListDemo(null);
        listDemo.mainImpl();
    }

    public ListDemo(SwingSet2 swingSet2) {
        super(swingSet2, "ListDemo", "toolbar/JList.gif");
        this.loadImages();
        JLabel jLabel = new JLabel(this.getString("ListDemo.description"));
        this.getDemoPanel().add((Component)jLabel, (Object)"North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add(Box.createRigidArea((Dimension)HGAP10));
        this.getDemoPanel().add((Component)jPanel, (Object)"Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel2.add(Box.createRigidArea((Dimension)VGAP10));
        jPanel.add((Component)jPanel2);
        jPanel.add(Box.createRigidArea((Dimension)HGAP30));
        this.list = new JList();
        this.list.setCellRenderer((ListCellRenderer)new CompanyLogoListCellRenderer());
        this.listModel = new GeneratedListModel(this);
        this.list.setModel((ListModel)this.listModel);
        this.list.setVisibleRowCount(22);
        JScrollPane jScrollPane = new JScrollPane((Component)this.list);
        jPanel2.add((Component)jScrollPane);
        jPanel2.add(Box.createRigidArea((Dimension)VGAP10));
        JPanel jPanel3 = this.createControlPanel();
        jPanel.add((Component)this.createControlPanel());
        this.addPrefix("Tera", true);
        this.addPrefix("Micro", false);
        this.addPrefix("Southern", false);
        this.addPrefix("Net", true);
        this.addPrefix("YoYo", true);
        this.addPrefix("Northern", false);
        this.addPrefix("Tele", false);
        this.addPrefix("Eastern", false);
        this.addPrefix("Neo", false);
        this.addPrefix("Digi", false);
        this.addPrefix("National", false);
        this.addPrefix("Compu", true);
        this.addPrefix("Meta", true);
        this.addPrefix("Info", false);
        this.addPrefix("Western", false);
        this.addPrefix("Data", false);
        this.addPrefix("Atlantic", false);
        this.addPrefix("Advanced", false);
        this.addPrefix("Euro", false);
        this.addPrefix("Pacific", false);
        this.addPrefix("Mobile", false);
        this.addPrefix("In", false);
        this.addPrefix("Computa", false);
        this.addPrefix("Digital", false);
        this.addPrefix("Analog", false);
        this.addSuffix("Tech", true);
        this.addSuffix("Soft", true);
        this.addSuffix("Telecom", true);
        this.addSuffix("Solutions", false);
        this.addSuffix("Works", true);
        this.addSuffix("Dyne", false);
        this.addSuffix("Services", false);
        this.addSuffix("Vers", false);
        this.addSuffix("Devices", false);
        this.addSuffix("Software", false);
        this.addSuffix("Serv", false);
        this.addSuffix("Systems", true);
        this.addSuffix("Dynamics", true);
        this.addSuffix("Net", false);
        this.addSuffix("Sys", false);
        this.addSuffix("Computing", false);
        this.addSuffix("Scape", false);
        this.addSuffix("Com", false);
        this.addSuffix("Ware", false);
        this.addSuffix("Widgets", false);
        this.addSuffix("Media", false);
        this.addSuffix("Computer", false);
        this.addSuffix("Hardware", false);
        this.addSuffix("Gizmos", false);
        this.addSuffix("Concepts", false);
    }

    public JPanel createControlPanel() {
        JPanel jPanel = new JPanel(){
            Insets insets = new Insets(0, 4, 10, 10);

            public Insets getInsets() {
                return this.insets;
            }
        };
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel2.add((Component)new JLabel(this.getString("ListDemo.prefixes")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
        jPanel3.add((Component)new JLabel(this.getString("ListDemo.suffixes")));
        this.prefixList = new JPanel(){
            Insets insets = new Insets(0, 4, 0, 0);

            public Insets getInsets() {
                return this.insets;
            }
        };
        this.prefixList.setLayout((LayoutManager)new BoxLayout((Container)this.prefixList, 1));
        JScrollPane jScrollPane = new JScrollPane((Component)this.prefixList);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jPanel2.add((Component)jScrollPane);
        jPanel2.add(Box.createRigidArea((Dimension)HGAP10));
        this.suffixList = new JPanel(){
            Insets insets = new Insets(0, 4, 0, 0);

            public Insets getInsets() {
                return this.insets;
            }
        };
        this.suffixList.setLayout((LayoutManager)new BoxLayout((Container)this.suffixList, 1));
        jScrollPane = new JScrollPane((Component)this.suffixList);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jPanel3.add((Component)jScrollPane);
        jPanel3.add(Box.createRigidArea((Dimension)HGAP10));
        jPanel.add((Component)jPanel2);
        jPanel.add(Box.createRigidArea((Dimension)HGAP15));
        jPanel.add((Component)jPanel3);
        return jPanel;
    }

    public void addPrefix(String string, boolean bl) {
        if (this.prefixAction == null) {
            this.prefixAction = new UpdatePrefixListAction(this.listModel);
        }
        JCheckBox jCheckBox = (JCheckBox)this.prefixList.add((Component)new JCheckBox(string));
        this.checkboxes.addElement(jCheckBox);
        jCheckBox.setSelected(bl);
        jCheckBox.addActionListener((ActionListener)this.prefixAction);
        if (bl) {
            this.listModel.addPrefix(string);
        }
    }

    public void addSuffix(String string, boolean bl) {
        if (this.suffixAction == null) {
            this.suffixAction = new UpdateSuffixListAction(this.listModel);
        }
        JCheckBox jCheckBox = (JCheckBox)this.suffixList.add((Component)new JCheckBox(string));
        this.checkboxes.addElement(jCheckBox);
        jCheckBox.setSelected(bl);
        jCheckBox.addActionListener((ActionListener)this.suffixAction);
        if (bl) {
            this.listModel.addSuffix(string);
        }
    }

    void loadImages() {
        this.images[0] = this.createImageIcon("list/red.gif", this.getString("ListDemo.red"));
        this.images[1] = this.createImageIcon("list/blue.gif", this.getString("ListDemo.blue"));
        this.images[2] = this.createImageIcon("list/yellow.gif", this.getString("ListDemo.yellow"));
        this.images[3] = this.createImageIcon("list/green.gif", this.getString("ListDemo.green"));
        this.images[4] = this.createImageIcon("list/gray.gif", this.getString("ListDemo.gray"));
        this.images[5] = this.createImageIcon("list/cyan.gif", this.getString("ListDemo.cyan"));
        this.images[6] = this.createImageIcon("list/magenta.gif", this.getString("ListDemo.magenta"));
    }

    class CompanyLogoListCellRenderer
    extends DefaultListCellRenderer {
        CompanyLogoListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setIcon((Icon)ListDemo.this.images[n % 7]);
            return component;
        }
    }

    class GeneratedListModel
    extends AbstractListModel {
        ListDemo demo;
        Permuter permuter;
        public Vector prefix = new Vector();
        public Vector suffix = new Vector();

        public GeneratedListModel(ListDemo listDemo2) {
            this.demo = listDemo2;
        }

        private void update() {
            this.permuter = new Permuter(this.getSize());
            this.fireContentsChanged((Object)this, 0, this.getSize());
        }

        public void addPrefix(String string) {
            if (!this.prefix.contains(string)) {
                this.prefix.addElement(string);
                this.update();
            }
        }

        public void removePrefix(String string) {
            this.prefix.removeElement(string);
            this.update();
        }

        public void addSuffix(String string) {
            if (!this.suffix.contains(string)) {
                this.suffix.addElement(string);
                this.update();
            }
        }

        public void removeSuffix(String string) {
            this.suffix.removeElement(string);
            this.update();
        }

        public int getSize() {
            return this.prefix.size() * this.suffix.size();
        }

        public Object getElementAt(int n) {
            if (this.permuter == null) {
                this.update();
            }
            int n2 = this.permuter.map(n);
            int n3 = this.prefix.size();
            int n4 = this.suffix.size();
            return (String)this.prefix.elementAt(n2 % n3) + (String)this.suffix.elementAt(n2 / n3 % n4);
        }
    }

    class UpdateSuffixListAction
    extends AbstractAction {
        GeneratedListModel listModel;

        protected UpdateSuffixListAction(GeneratedListModel generatedListModel) {
            this.listModel = generatedListModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.listModel.addSuffix(jCheckBox.getText());
            } else {
                this.listModel.removeSuffix(jCheckBox.getText());
            }
        }
    }

    class UpdatePrefixListAction
    extends AbstractAction {
        GeneratedListModel listModel;

        protected UpdatePrefixListAction(GeneratedListModel generatedListModel) {
            this.listModel = generatedListModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.listModel.addPrefix(jCheckBox.getText());
            } else {
                this.listModel.removePrefix(jCheckBox.getText());
            }
        }
    }
}

