/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.ListenerList;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    protected Properties properties;
    protected Map children;
    protected IEclipsePreferences parent;
    protected boolean removed = false;
    protected String name;
    protected ListenerList nodeListeners;
    protected ListenerList preferenceListeners;
    protected boolean isLoading = false;
    protected boolean dirty = false;
    protected boolean loading = false;
    private String cachedPath;

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(IEclipsePreferences parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    protected void log(IStatus status) {
        InternalPlatform.getDefault().log(status);
    }

    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(DEFAULT_PREFERENCES_DIRNAME).append(qualifier).addFileExtension(PREFS_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(IPath location) throws BackingStoreException {
        Properties fromDisk;
        block13: {
            if (location == null) {
                if (!InternalPlatform.DEBUG_PREFERENCES) return;
                System.out.println("Unable to determine location of preference file for node: " + this.absolutePath());
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from file: " + location);
            }
            BufferedInputStream input = null;
            fromDisk = new Properties();
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(location.toFile()));
                    fromDisk.load(input);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("Preference file does not exist: " + location);
                    }
                    Object var6_4 = null;
                    if (input == null) return;
                    try {
                        ((InputStream)input).close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                catch (IOException e) {
                    String message = Policy.bind("preferences.loadException", location.toString());
                    this.log(new Status(1, "org.eclipse.core.runtime", 1, message, e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (input == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                ((InputStream)input).close();
                throw throwable;
                throw throwable;
            }
            {
                Object var6_6 = null;
                if (input == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)input).close();
        }
        this.convertFromProperties(fromDisk);
    }

    /*
     * Exception decompiling
     */
    public void save(IPath location) throws BackingStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 275->279)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkRemoved() {
        if (this.removed) {
            String message = Policy.bind("preferences.removedNode", this.name);
            throw new IllegalStateException(message);
        }
    }

    public void put(String key, String newValue) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue, newValue);
        }
    }

    public String get(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        return this.properties == null ? defaultValue : this.properties.getProperty(key, defaultValue);
    }

    public void remove(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String oldValue = this.properties.getProperty(key);
        if (oldValue != null) {
            this.internalRemove(key, oldValue);
        }
    }

    public void removeInt(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String stringValue = this.properties.getProperty(key);
        if (stringValue != null) {
            Integer oldValue = null;
            try {
                oldValue = Integer.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
            this.internalRemove(key, oldValue);
        }
    }

    public void removeDouble(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String stringValue = this.properties.getProperty(key);
        if (stringValue != null) {
            Double oldValue = null;
            try {
                oldValue = Double.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
            this.internalRemove(key, oldValue);
        }
    }

    public void removeFloat(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String stringValue = this.properties.getProperty(key);
        if (stringValue != null) {
            Float oldValue = null;
            try {
                oldValue = Float.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
            this.internalRemove(key, oldValue);
        }
    }

    public void removeLong(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String stringValue = this.properties.getProperty(key);
        if (stringValue != null) {
            Long oldValue = null;
            try {
                oldValue = Long.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
            this.internalRemove(key, oldValue);
        }
    }

    public void removeBoolean(String key) {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        String stringValue = this.properties.getProperty(key);
        if (stringValue != null) {
            this.internalRemove(key, Boolean.valueOf(stringValue));
        }
    }

    private void internalRemove(String key, Object oldValue) {
        this.properties.remove(key);
        if (this.properties.size() == 0) {
            this.properties = null;
        }
        this.makeDirty();
        this.preferenceChanged(key, oldValue, null);
    }

    public void clear() throws BackingStoreException {
        this.checkRemoved();
        if (this.properties == null) {
            return;
        }
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            this.remove((String)e.nextElement());
        }
        this.properties = null;
        this.makeDirty();
    }

    public void putInt(String key, int value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = Integer.toString(value);
        Object oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Integer((String)oldValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.preferenceChanged(key, oldValue, new Integer(newValue));
        }
    }

    public int getInt(String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putLong(String key, long value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = Long.toString(value);
        Object oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Long((String)oldValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.preferenceChanged(key, oldValue, new Long(newValue));
        }
    }

    public long getLong(String key, long defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putBoolean(String key, boolean value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = value ? TRUE : FALSE;
        String oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue == null ? null : new Boolean(oldValue), value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public void putFloat(String key, float value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = Float.toString(value);
        Object oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Float((String)oldValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.preferenceChanged(key, oldValue, new Float(newValue));
        }
    }

    public float getFloat(String key, float defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putDouble(String key, double value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = Double.toString(value);
        Object oldValue = this.properties.getProperty(key);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Double((String)oldValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.preferenceChanged(key, oldValue, new Double(newValue));
        }
    }

    public double getDouble(String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putByteArray(String key, byte[] value) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String newValue = null;
        String oldValue = this.properties.getProperty(key);
        newValue = new String(value);
        this.properties.put(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue == null ? null : oldValue.getBytes(), value);
        }
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        if (this.properties == null) {
            return defaultValue;
        }
        String value = this.properties.getProperty(key);
        return value == null ? defaultValue : value.getBytes();
    }

    public String[] keys() throws BackingStoreException {
        this.checkRemoved();
        if (this.properties == null || this.properties.size() == 0) {
            return new String[0];
        }
        return new ArrayList<Object>(this.properties.keySet()).toArray(new String[this.properties.size()]);
    }

    public String[] childrenNames() throws BackingStoreException {
        this.checkRemoved();
        if (this.children == null || this.children.size() == 0) {
            return new String[0];
        }
        return new ArrayList(this.children.keySet()).toArray(new String[this.children.size()]);
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    public Preferences node(String pathName) {
        return this.node(new Path(pathName));
    }

    protected void makeClean() {
        block2: {
            IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) {
                    ((EclipsePreferences)node).dirty = false;
                    return true;
                }
            };
            try {
                this.accept(visitor);
            }
            catch (BackingStoreException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block2;
                System.out.println("Exception visiting nodes during #makeClean");
                e.printStackTrace();
            }
        }
    }

    protected void makeDirty() {
        EclipsePreferences node = this;
        while (node != null && !node.dirty && !node.removed) {
            node.dirty = true;
            node = (EclipsePreferences)node.parent();
        }
    }

    private IEclipsePreferences calculateRoot() {
        IEclipsePreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    public IEclipsePreferences node(IPath path) {
        if (path.isAbsolute()) {
            return this.calculateRoot().node(path.makeRelative());
        }
        this.checkRemoved();
        if (path.isEmpty()) {
            return this;
        }
        String key = path.segment(0);
        IEclipsePreferences child = null;
        if (this.children != null) {
            child = (IEclipsePreferences)this.children.get(key);
        }
        if (child == null) {
            child = this.create(this, key);
            if (this.children == null) {
                this.children = new HashMap();
            }
            this.children.put(key, child);
            this.nodeAdded(child);
        }
        return child.node(path.removeFirstSegments(1));
    }

    protected void nodeAdded(IEclipsePreferences child) {
        if (this.nodeListeners == null) {
            return;
        }
        Object[] listeners = this.nodeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEclipsePreferences.INodeChangeListener)listeners[i]).added(new IEclipsePreferences.NodeChangeEvent(this, child));
            ++i;
        }
    }

    protected void nodeRemoved(IEclipsePreferences child) {
        if (this.nodeListeners == null) {
            return;
        }
        Object[] listeners = this.nodeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEclipsePreferences.INodeChangeListener)listeners[i]).removed(new IEclipsePreferences.NodeChangeEvent(this, child));
            ++i;
        }
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.nodeExists(new Path(pathName));
    }

    public boolean nodeExists(IPath path) throws BackingStoreException {
        if (path.isAbsolute()) {
            return this.calculateRoot().nodeExists(path.makeRelative());
        }
        if (path.isEmpty()) {
            return !this.removed;
        }
        this.checkRemoved();
        if (this.children == null) {
            return false;
        }
        String key = path.segment(0);
        IEclipsePreferences child = (IEclipsePreferences)this.children.get(key);
        if (child == null) {
            return false;
        }
        return child.nodeExists(path.removeFirstSegments(1));
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        if (!(this.parent instanceof RootPreferences)) {
            if (this.parent instanceof EclipsePreferences) {
                this.removed = true;
                ((EclipsePreferences)this.parent).removeNode(this);
            } else {
                String message = Policy.bind("preferences.invalidParentClass", this.absolutePath(), this.parent.getClass().getName());
                throw new BackingStoreException(message);
            }
        }
        if (this.children != null) {
            Preferences[] nodes = this.children.values().toArray(new Preferences[this.children.size()]);
            int i2 = 0;
            while (i2 < nodes.length) {
                nodes[i2].removeNode();
                ++i2;
            }
        }
    }

    protected void removeNode(IEclipsePreferences child) {
        if (this.children != null && this.children.remove(child.name()) != null) {
            this.makeDirty();
            this.nodeRemoved(child);
        }
        if (this.children != null && this.children.isEmpty()) {
            this.children = null;
        }
    }

    public String name() {
        return this.name;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            this.cachedPath = this.parent == null ? Path.ROOT.toString() : new Path(this.parent.absolutePath()).append(this.name()).toString();
        }
        return this.cachedPath;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeListeners == null) {
            this.nodeListeners = new ListenerList();
        }
        this.nodeListeners.add(listener);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Added preference node change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceListeners == null) {
            this.preferenceListeners = new ListenerList();
        }
        this.preferenceListeners.add(listener);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Added preference property change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeListeners == null) {
            return;
        }
        this.nodeListeners.remove(listener);
        if (this.nodeListeners.size() == 0) {
            this.nodeListeners = null;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Removed preference node change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceListeners == null) {
            return;
        }
        this.preferenceListeners.remove(listener);
        if (this.preferenceListeners.size() == 0) {
            this.preferenceListeners = null;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Removed preference property change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    protected void preferenceChanged(String key, Object oldValue, Object newValue) {
        if (this.preferenceListeners == null) {
            return;
        }
        Object[] listeners = this.preferenceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEclipsePreferences.IPreferenceChangeListener)listeners[i]).preferenceChange(new IEclipsePreferences.PreferenceChangeEvent(this, key, oldValue, newValue));
            ++i;
        }
    }

    public String toDeepDebugString() {
        final StringBuffer buffer = new StringBuffer();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                buffer.append(node);
                buffer.append('\n');
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    buffer.append(node.absolutePath());
                    buffer.append('/');
                    buffer.append(keys[i]);
                    buffer.append('=');
                    buffer.append(node.get(keys[i], "*default*"));
                    buffer.append('\n');
                    ++i;
                }
                return true;
            }
        };
        try {
            this.accept(visitor);
        }
        catch (BackingStoreException e) {
            System.out.println("Exception while calling #toDeepDebugString()");
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        if (!this.dirty) {
            return;
        }
        IEclipsePreferences loadLevel = this.getLoadLevel();
        if (loadLevel == null) {
            String[] childrenNames = this.childrenNames();
            int i = 0;
            while (i < childrenNames.length) {
                this.node(childrenNames[i]).flush();
                ++i;
            }
            return;
        }
        if (this != loadLevel) {
            loadLevel.flush();
            return;
        }
        this.save(this.getLocation());
        this.makeClean();
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    protected void loadLegacy() {
    }

    protected void loaded() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        EclipsePreferences result = this.internalCreate(nodeParent, nodeName);
        IEclipsePreferences loadLevel = result.getLoadLevel();
        if (loadLevel == null) {
            return result;
        }
        if (result != loadLevel) {
            return result;
        }
        if (this.isAlreadyLoaded(result)) {
            return result;
        }
        if (this.loading) {
            return result;
        }
        try {
            try {
                this.loading = true;
                result.loadLegacy();
                result.load(result.getLocation());
                result.loaded();
                result.flush();
            }
            catch (BackingStoreException e) {
                String message = "Exception loading preferences";
                Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                InternalPlatform.getDefault().log(status);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.loading = false;
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.loading = false;
            return result;
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return true;
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName) {
        return new EclipsePreferences(nodeParent, nodeName);
    }

    private void convertFromProperties(Properties table) {
        Path fullPath = new Path(this.absolutePath());
        Iterator<Object> i = table.keySet().iterator();
        while (i.hasNext()) {
            Path childPath;
            String key = (String)i.next();
            String value = table.getProperty(key);
            if (value == null || (childPath = new Path(key)).segmentCount() <= 0) continue;
            key = childPath.lastSegment();
            IPath child = childPath.removeLastSegments(1);
            if (fullPath.isPrefixOf(childPath)) {
                child = child.removeFirstSegments(fullPath.segmentCount());
                this.node(child).put(key, value);
                continue;
            }
            if (!InternalPlatform.DEBUG_PREFERENCES) continue;
            System.out.println("Ignoring value: " + value + " for key: " + childPath + " for node: " + fullPath);
        }
    }

    private Properties convertToProperties(Properties result, IPath prefix) throws BackingStoreException {
        Iterator<Object> i;
        if (this.properties != null) {
            i = this.properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = this.properties.getProperty(key, null);
                if (value == null) continue;
                result.put(prefix.append(key).toString(), value);
            }
        }
        if (this.children != null) {
            i = this.children.values().iterator();
            while (i.hasNext()) {
                EclipsePreferences child = (EclipsePreferences)i.next();
                child.convertToProperties(result, prefix.append(child.name()));
            }
        }
        return result;
    }

    protected boolean isLoading() {
        if (this.parent instanceof EclipsePreferences) {
            return this.isLoading || ((EclipsePreferences)this.parent).isLoading();
        }
        return this.isLoading;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit(this) || this.children == null) {
            return;
        }
        Iterator i = this.children.values().iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof IEclipsePreferences)) continue;
            ((IEclipsePreferences)next).accept(visitor);
        }
    }
}

