/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

public class XMLContentDescriber
implements IContentDescriber {
    private static final String XML_PREFIX = "<?xml ";
    private static final String ENCODING = "encoding=\"";

    public int describe(InputStream input, IContentDescription description, int flags) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        String line = reader.readLine();
        if (line == null) {
            return 1;
        }
        if (!line.startsWith(XML_PREFIX)) {
            return -1;
        }
        if ((flags & 1) != 0) {
            description.setCharset(this.getCharset(line));
        }
        return 0;
    }

    public int getSupportedOptions() {
        return 1;
    }

    private String getCharset(String firstLine) {
        int encodingPos = firstLine.indexOf(ENCODING);
        if (encodingPos == -1) {
            return null;
        }
        int firstQuote = firstLine.indexOf(34, encodingPos);
        if (firstQuote == -1 || firstLine.length() == firstQuote - 1) {
            return null;
        }
        int secondQuote = firstLine.indexOf(34, firstQuote + 1);
        if (secondQuote == -1) {
            return null;
        }
        return firstLine.substring(firstQuote + 1, secondQuote);
    }
}

