/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

public final class Converter {
    static final byte[] NULL_BYTE_ARRAY = new byte[1];
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static String CodePage;
    static byte[] Unicode;

    static {
        Unicode = Converter.getAsciiBytes("UCS-2");
    }

    public static String defaultCodePage() {
        return CodePage;
    }

    static byte[] getAsciiBytes(String str) {
        int length = str.length();
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        return buffer;
    }

    public static char[] mbcsToWcs(String codePage, byte[] buffer) {
        if (buffer == null) {
            return EMPTY_CHAR_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        String s = new String(buffer);
        int n = s.length();
        char[] chars = new char[n];
        s.getChars(0, n, chars, 0);
        return chars;
    }

    public static void release() {
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer) {
        return Converter.wcsToMbcs(codePage, buffer, false);
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer, boolean terminate) {
        if (buffer == null) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        String s = new String(buffer);
        byte[] b = s.getBytes();
        if (!terminate) {
            return b;
        }
        byte[] b2 = new byte[b.length + 1];
        System.arraycopy(b, 0, b2, 0, b.length);
        return b2;
    }

    public static byte[] wcsToMbcs(String codePage, String string) {
        return Converter.wcsToMbcs(codePage, string, false);
    }

    public static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        if (terminate) {
            if (string == null) {
                return NULL_BYTE_ARRAY;
            }
            int count = string.length();
            char[] buffer = new char[count + 1];
            string.getChars(0, count, buffer, 0);
            return Converter.wcsToMbcs(codePage, buffer, false);
        }
        if (string == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int count = string.length();
        char[] buffer = new char[count];
        string.getChars(0, count, buffer, 0);
        return Converter.wcsToMbcs(codePage, buffer, false);
    }
}

