/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#ifndef __CURSOR_H__
#define __CURSOR_H__


/*
 * ag_input_text_rewrite_char
 * @pos:     position on the text
 * rewrites the character at @pos with out the cursor,
 * but it does write the error hilight if needed.
 * sets the text point to @pos.
 */
void
ag_input_text_rewrite_char(gint pos);



/*
 * ag_input_text_rewrite_cursor
 * rewrites the character at pos, with the cursor
 * over it, it also sets the text point to pos.
 */
void
ag_input_text_rewrite_cursor(gint pos);



/*
 * ag_cursor_move_forward
 * moves the cursor one character ahead.
 */
void
ag_cursor_move_forward();



/*
 * ag_cursor_move_backward
 * moves the cursor one character back.
 */
void
ag_cursor_move_backward();




#endif /* __CURSOR_H__ */
