/*
 * robglob.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Implements the Globals class (the settings corresponding to a RCO file)

#include "robglob.h"

#include "robbase.h"
#include "robpackage.h"

using namespace lrt;

namespace rt {

bool Globals::getGlobals(const String& filex)
{
	IniFile ini;
	
	String filename = findOptionSet(filex); 
	if(!ini.read(filename)) return false;

	//																		only if necessary
	// variable         = type     section   name                   default min		max
	// -------------------------------------------------------------------------------------------
	IniSection& sRoboCom = ini.getSection("RoboCom");
	fields              = getRint( sRoboCom, "Fields",				16,		1);
	fieldsX             = getRint( sRoboCom, "FieldsX",				fields,	1);
	fieldsY             = getRint( sRoboCom, "FieldsY",				fields,	1);
	enableElim			= getRint( sRoboCom, "EnableElim",			1,		0,		1);
	elim                = getRint( sRoboCom, "ElimTrigger",			50,		0);
	timeout             = getInt(  sRoboCom, "AutoTimeout",			80000,	1);
	maxCreateDur        = getRint( sRoboCom, "MaxCreateDur",		1500,	0);
	maxSleepDur         = getRint( sRoboCom, "MaxSleepDur",			2000,	0);
	maxInstrDur         = getRint( sRoboCom, "MaxInstrDur",			2000,	0);
	maxGeneration       = getRint( sRoboCom, "MaxGeneration",		32000,	0);
	firstRobotMobile    = getRint( sRoboCom, "FirstRobotMobile",	0,		0,		1);
	enableRC3Instr      = getRint( sRoboCom, "EnableRC3instr",		0,		0,		1);
	enableMultitasking  = getRint( sRoboCom, "EnableMultitasking",	0,		0,		1);
	enableFAT           = getRint( sRoboCom, "FAT",					0,		0,		1);
	enableLifetime		= getRint( sRoboCom, "EnableLifetime",		0,		0,		1);
	enableNutcracker    = getRint( sRoboCom, "NutCracker",          1,      0,      1);
	minId				= getRint( sRoboCom, "MinID",				5000);
	maxId				= getRint( sRoboCom, "MaxID",				25000,	minId);

	maxInstr            = getRint( sRoboCom, "MaxInstr",			1000,	1);
	maxBanks            = getRint( sRoboCom, "MaxBanks",			50,		1);
	maxVars				= getRint( sRoboCom, "MaxVars",				20,		1);
	maxTasks			= getRint( sRoboCom, "MaxTasks",			1,		1);
	maxMybots           = getRint( sRoboCom, "MaxMyBots",			32000,	1);
	maxLifetime			= getInt( sRoboCom, "MaxLifetime",			32000000,1);

	IniSection& sTiming  = ini.getSection("Timing");
	durDie             = getRint( sTiming, "durDie",				1,		0 );
	durMove            = getRint( sTiming, "durMove",				18,		0 );
	durTurn            = getRint( sTiming, "durTurn",				5,		0 );
	durAjump           = getRint( sTiming, "durAJump",				2,		0 );
	durJump            = getRint( sTiming, "durJump",				2,		0 );
	durBjump           = getRint( sTiming, "durBJump",				5,		0 );
	durScan            = getRint( sTiming, "durScan",				6,		0 );
	durFarscan         = getRint( sTiming, "durFarscan",		durScan,	0 );
	durFarscanPerField = getRint( sTiming, "durFarscanPerField", durFarscan / 2, 0 );
	durSet             = getRint( sTiming, "durSet",				5,		0 );
	durAdd             = getRint( sTiming, "durAdd",				6,		0 );
	durSub             = getRint( sTiming, "durSub",				6,		0 );
	durMul             = getRint( sTiming, "durMul",				12,		0 );
	durDiv             = getRint( sTiming, "durDiv",				12,		0 );
	durMod             = getRint( sTiming, "durMod",				12,		0 );
	durMin             = getRint( sTiming, "durMin",				6,		0 );
	durMax             = getRint( sTiming, "durMax",				6,		0 );
	durTrans           = getRint( sTiming, "durTrans1",				5,		0 );
	durTransPerInstr   = getRint( sTiming, "durTrans2",				3,		0 );
	durRtrans          = getRint( sTiming, "durRTrans1",			5,		0 );
	durRtransPerInstr  = getRint( sTiming, "durRTrans2",			3,		0 );
	durComp            = getRint( sTiming, "durComp",				3,		0 );
	durLcomp           = getRint( sTiming, "durLComp",				6,		0 );
	durGcomp           = getRint( sTiming, "durGComp",				6,		0 );
	durNcomp           = getRint( sTiming, "durNComp",				3,		0 );
	durRandom          = getRint( sTiming, "durRandom",				6,		0 );
	durCreate          = getRint( sTiming, "durCreate1",			50,		0 );
	durCreatePerBank   = getRint( sTiming, "durCreate2",			20,		0 );
	durCreateMulMobile = getRint( sTiming, "durCreate3",			2,		0 );
	durCreateAddMobile = getRint( sTiming, "durCreate3a",			0,		0 );
	durCreateAdvISet   = getRint( sTiming, "durCreate4",			40,		0 );
	durCreateSuperISet = getRint( sTiming, "durCreate5",			80,		0 );

	durBreak           = getRint( sTiming, "durBreak",				3,		0 );
	durInit            = getRint( sTiming, "durInit",				5,		0 );
	durSeize           = getRint( sTiming, "durSeize",				3,		0 );
	durResume          = getRint( sTiming, "durResume",				3,		0 );
	durQuit            = getRint( sTiming, "durQuit",				3,		0 );
	
	durRemote          = getRint( sTiming, "durRemoteAcc",			8,		0 );

	return true;
}

// Fetches a rint from an ini file section
rint Globals::getRint( IniSection& sec, const char* name, rint def, rint min, rint max)
{
	String& v = sec.get(name);
	int val = v.intValue(def);

	if((val == def) && (def < 0))
		errHandler->handleSystemError(11, String("Could not find option ") + name);

	if(val < min)
		errHandler->handleSystemError(19, String("Invalid RCO option ") + name + ": " + val + " < " + min);
	if(val > max)
		errHandler->handleSystemError(19, String("Invalid RCO option ") + name + ": " + val + " > " + max);

	return (rint)val;
}

// Fetches a int from an ini file section
int Globals::getInt( IniSection& sec, const char* name, int def, int min, int max)
{
	String& v = sec.get(name);
	int val = v.intValue(def);

	if((val == def) && (def < 0))
		errHandler->handleSystemError(11, String("Could not find option ") + name);

	if(val < min)
		errHandler->handleSystemError(19, String("Invalid RCO option ") + name + ": " + val + " < " + min);
	if(val > max)
		errHandler->handleSystemError(19, String("Invalid RCO option ") + name + ": " + val + " > " + max);

	return val;
}

} // namespace

