/*
 *  about-dialog.c       -
 *
 *  Created: 20020126
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: about-dialog.c,v 1.8 2002/03/19 19:09:31 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <about-dialog.h>

#include <intl.h>
#include <common.h>

void about_menu(GtkWidget *widget, GtkWidget *parent)
{
    GtkWidget *about_dialog;
    GtkWidget *dialog_vbox;
    GtkWidget *label;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;
    
    g_assert(parent != NULL);
    
    /* Utworzenie okienka dialogowego. */
    about_dialog = gtk_dialog_new();
    
    /* Przypisanie funkcji obsugi sygnaw do okienka dialogowego. */
    gtk_signal_connect(GTK_OBJECT(about_dialog), "delete_event",
                       GTK_SIGNAL_FUNC(dialog_delete), about_dialog);
    gtk_signal_connect(GTK_OBJECT(about_dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(dialog_key_press), about_dialog);
    
    /* Ustalenie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(about_dialog), _("About..."));
    gtk_widget_set_usize(GTK_WIDGET(about_dialog), 300, 200);
    
        /* Obszar wnetrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(about_dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Etykieta z informacyjami. */
	    label = gtk_label_new("Rigel\nTomasz Trojanowski");
	    gtk_widget_show(label);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_vbox), label, TRUE, TRUE, 0);
    
        /* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(about_dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox, TRUE, TRUE, 0);
	    
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
	        /* Przycisk "OK". */
		button = gtk_button_new_with_label(_("OK"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(dialog_delete), about_dialog);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		
		gtk_widget_grab_focus(button);
		gtk_widget_grab_default(button);
    
    /* Wywietlanie okienka dialogowego. */
    gtk_widget_show(about_dialog);
    
    /* Ustalanie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(about_dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(about_dialog), GTK_WINDOW(parent));
}
