\name{resolve.depends}
\alias{resolve.depends}
\alias{findInstallDepends}
\alias{solveForwardDepends}
\title{A function to check for dependency breakages}
\description{
  Given a particular package, will check to insure that no dependencies
  are being broken if this package were to be changed (newer version
  installed, package removed, etc).
}
\usage{
resolve.depends(pkg, repEntry, force = FALSE, forward = TRUE, lib =
                 reposToolsLibPaths()[1], remove = FALSE, depends = TRUE,
                 suggests = TRUE, imports = TRUE, searchOptions = TRUE,
                 getAllDeps = FALSE, versForce = TRUE, method =
                 "auto", getNewest = FALSE, develOK=FALSE, curRepList=NULL)
}
\arguments{
  \item{pkg}{A pkgInfo object describing the package}
  \item{repEntry}{The \code{ReposEntry} object the package is coming from}
  \item{force}{Logical, if force==TRUE, will only \code{warn} the user
    of dependencies, instead of \code{stop}ing}
  \item{forward}{Whether to check for and attempt to aquire any
    dependencies this package might have that are not already installed}
  \item{lib}{Library that the original package is in}
  \item{remove}{Logical to flag if the user is seeking to remove \code{pkg}}
  \item{depends}{Whether to \code{stop} on unresolved \code{depends}
    level dependencies}
  \item{suggests}{Whether to \code{stop} on unresolved \code{suggests}
    level dependencies}
  \item{imports}{Whether to \code{stop} on unresolved \code{imports} level dependencies}
  \item{searchOptions}{Corresponds with the \code{searchOptions}
    argument to \code{update.packages2} - used if downloading a package
    due to forward=TRUE}
   \item{getAllDeps}{Will automatically download all dependencies if
     TRUE, otherwise will prompt the user}
   \item{versForce}{Whether or not to override R version checking on
    binary packages}
   \item{method}{What download method to use if any packages are
     downloaded and installed.  See the same parameter for \code{install.packages2}}
   \item{getNewest}{Passed down to any install.packages2() call internally}
   \item{develOK}{If any packages are needed to be downloaded, if it is
     okay to get packages of \code{devel} release level}
   \item{curRepList}{The current list of repositories being used by the
     installation functions, used to search for any dependencies.}
 }
\details{
  Will look for a local library listing file in every library specified
  by \code{libs}.  If one exists, will check packages in that R library
  to see if the desired action would break any dependency links.  For
  instance, if package X depends on package Y version 2, and the user is
  looking to upgrade package Y to version 3 - or if the user wants to
  remove package Y altogether.

  By default, the system will \code{stop} for any unresolved
  \code{depends} and \code{suggests} level dependencies, but only throw
  a \code{warning} on any \code{imports} level dependencies.  These can be
  toggled by the user.

  If \code{force == TRUE}, only \code{warnings} will be given.
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgInfo}},\code{\link{depends}},\code{\link{syncLocalLibList}}}

\examples{
}
\keyword{utilities}
