/*
 * QToggleButton.cpp
 * $Id: QToggleButton.cpp,v 1.4 2001/11/20 16:23:49 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QToggleButton
//  Purpose     : Provides funcionality of a togglebutton with two pixmaps


// Qt
///////
#include <qpixmap.h>
#include <qwidget.h>
#include <qstring.h>


// System
///////////


// Own
///////////
#include "QToggleButton.h"




// Function  : QToggleButton
// Parameters: QWidget *parent, const char *name
// Purpose   : default constructor.
// Comments  : See docu for details.
QToggleButton::QToggleButton(QWidget *parent, const char *name)
  : QPushButton(parent, name), toggled_btext(""), toggled_bpixmap(0)
/*********************************************************************/
{
   setToggleButton(true);
   connect(this, SIGNAL(toggled(bool)), this, SLOT(togglePixmap(bool)));
}



// Function  : 
// Parameters: const char *text1, const char *text2,
//             QWidget *parent, const char *name
// Purpose   : constructor with two init strings
// Comments  : See docu for details.
QToggleButton::QToggleButton(const char *text1, const char *text2,
			      QWidget *parent, const char *name)
  : QPushButton(text1, parent, name), toggled_bpixmap(0)
/*********************************************************************/
{
   toggled_btext = QString(text2);
   setToggleButton(true);
   connect(this, SIGNAL(toggled(bool)), this, SLOT(togglePixmap(bool)));
}



// Function  : ~QToggleButton
// Parameters: 
// Purpose   : default destructor.
// Comments  : See docu for details.
QToggleButton::~QToggleButton()
/*********************************************************************/
{
   if(toggled_bpixmap)
      delete toggled_bpixmap;
}



// Function  : togglePixmap
// Parameters: bool fOn
// Purpose   : 
// Comments  : See docu for details.
void QToggleButton::togglePixmap(bool fOn)
/*********************************************************************/
{
   if(toggled_bpixmap  && !(pixmap()->isNull())) {
      QPixmap dummy = *pixmap();
      QPushButton::setPixmap(*toggled_bpixmap);
      *toggled_bpixmap = dummy;
   }
   if(text() && !toggled_btext.isNull()) {
      QString dummy = QString(text());
      QPushButton::setText(toggled_btext.data());
      toggled_btext = dummy;
   }
}



// Function  : setText
// Parameters: const QString &up_text, const QString &down_text
// Purpose   : sets the two text strings.
// Comments  : See docu for details.
void QToggleButton::setText(const QString &up_text, const QString &down_text)
/*********************************************************************/
{
   QPushButton::setText(up_text);
   toggled_btext = QString(down_text);
}



// Function  : setPixmap
// Parameters: const QPixmap &up_pixmap, const QPixmap &down_pixmap
// Purpose   : sets the two pixmaps.
// Comments  : See docu for details.
void QToggleButton::setPixmap(const QPixmap &up_pixmap, const QPixmap &down_pixmap)
/*********************************************************************/
{
   QPushButton::setPixmap(up_pixmap);
   if(toggled_bpixmap) 
      delete toggled_bpixmap;
   toggled_bpixmap = new QPixmap(down_pixmap);
   Q_CHECK_PTR(toggled_bpixmap);
}
