/*
 * QGLViewerIO.cpp
 * $Id: 
 *
 * Copyright (C) 2001 Alexander Buck, Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */


// Qt
///////
#include <qfile.h>
#include <qtextstream.h>


// QGLViewer
//////////////
#include "CList.h"
#include "QGLViewerIO.h"
#include "QGLViewerXML.h"
#include "CCameraKeyPathPoint.h"
#include "CCamera.h"


// Function : read
// Purpose  : Reads CameraPath
// Comments :
bool QGLViewerIO::read(QFile &file, CList<CCameraKeyPathPoint> &list) 
/****************************************************************/
{
  bool ret=false;

   if (!file.open(IO_ReadOnly)){
      cout << "Can not open file" << endl;
      return false;
   }
    
   QDomDocument doc("load CameraKeyPath");

   if (doc.setContent(&file))
     ret = QGLViewerXML::readXML(doc.documentElement(), list, "CameraKeyPath");

   file.close();

   return ret;
}


// Function : write
// Purpose  : Writes CameraPath
// Comments :
bool QGLViewerIO::write(QFile &file, CList<CCameraKeyPathPoint> &list) 
/****************************************************************/
{
   QDomDocument doc("save CameraKeyPath");    
   QDomElement elem = doc.createElement("CameraKeyPath");
   doc.appendChild(elem);

   if (QGLViewerXML::writeXML(elem, list, "CameraKeyPath")) {
	
      if (!file.open(IO_WriteOnly)){
         cout << "Can not open file" << endl;
         return false;
      }
	
      QTextStream qStream(&file);
      doc.firstChild().save(qStream, 0);
      file.close();
   }
   else
     return false;

   return true;
}



// Function : read
// Purpose  : read QFile to CameraPath
// Comments :
bool QGLViewerIO::read(QFile &file, CList<CCamera> &list) 
/**********************************************************/
{
  bool ret=false;

   if (!file.open(IO_ReadOnly))
      return false;
    
   QDomDocument doc("glviewer/camerapath");
    
   if (doc.setContent(&file))
      ret = QGLViewerXML::readXML(doc.documentElement(), list, "CameraPath");
    
   file.close();

   return ret;
}



// Function : write
// Purpose  : write CameraPath to QFile
// Comments :
bool QGLViewerIO::write(QFile &file, CList<CCamera> &list) 
/**********************************************************/
{
   QDomDocument doc("glviewer/camerapath");    
   QDomElement elem = doc.createElement("CameraPath");
   doc.appendChild(elem);


   if (QGLViewerXML::writeXML(elem, list, "CameraPath")) {
	
      if (!file.open(IO_WriteOnly))
         return false;
	
      QTextStream qStream(&file);
      doc.firstChild().save(qStream, 0);
      file.close();
   }
   else
     return false;

   return true;
}
