/*
 * QGLSignalWidget.h
 * $Id: QGLSignalWidget.h,v 1.5 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QGLSignalWidget
//  Purpose     : Provides a OpenGL render area


#ifndef _QGLSIGNALWIDGET_H_
#define _QGLSIGNALWIDGET_H_


// Qt
///////
#include <qgl.h>
#include <qevent.h>
#include <qdragobject.h>


// System
///////////


// Own
///////////




/**
  * Internal abstract class for GLViewers
  *
  * This is an internal abstract class which is only designed for
  * the use in the class QGLViewer. DON'T use this class directly !!!
  *
  * @author Markus Janich
  *
  */

class QGLSignalWidget: public QGLWidget {
  Q_OBJECT

public:

  /** Default Constructor */
  QGLSignalWidget(QWidget * parent=0, const char * name=0, 
		const QGLWidget * shareWidget = 0, WFlags f=0)
    : QGLWidget(parent, name, shareWidget, f)
  {
    //setFocusPolicy(NoFocus);
    setAcceptDrops(true);
  };

  /** Default Constructor */
  QGLSignalWidget(const QGLFormat & format, QWidget * parent=0, 
		const char * name=0, const QGLWidget * shareWidget = 0, 
		WFlags f=0)
    : QGLWidget(format, parent, name, shareWidget, f)
  {
    //setFocusPolicy(NoFocus);
    setAcceptDrops(true);
  };


signals:

  /** This signal is once emitted if the widget will be showed 
    * and before any drawing were done. */
  void sigInitGL();

  /** This signal is emitted if the scene should be redrawed. */ 
  void sigRedrawGL();

  /** This signal is emitted if the widget was resized and
    * the scene should be redrawed. */
  void sigResizeGL(int nWidth, int nHeight);

  /** This Signal is emitted if any mousebutton has been released
    * over the QGLSignalWidget. */
  void sigMouseRelease(QMouseEvent *pqEvent);

  /** This Signal is emitted if any mousebutton has been pressed
    * over the QGLSignalWidget. */
  void sigMousePress(QMouseEvent *pqEvent);

  /** This Signal is emitted if the mouse has been moved
    * over the QGLSignalWidget while any button(s) were pressed. */
  void sigMouseMove(QMouseEvent *pqEvent);

  void sigDragEnter(QDragEnterEvent *pqEvent);
  void sigDragLeave(QDragLeaveEvent *pqEvent);
  void sigDrop(QDropEvent *pqEvent);

protected:

  /** Initializes GL context */
  virtual void initializeGL() {
    emit( sigInitGL() );
  };

  /** Implements painting into GL area */
  virtual void paintGL() {
    emit( sigRedrawGL() );
  };

  /** Implements resizing the GL area */
  virtual void resizeGL(int nWidth, int nHeight) {
    emit( sigResizeGL(nWidth, nHeight) );
  };

  /** Implements mouse-release event */
  virtual void mouseReleaseEvent (QMouseEvent *event) {
    emit(sigMouseRelease(event));
  };

  /** Implements mouse-press event */
  virtual void mousePressEvent (QMouseEvent *event) {
    emit(sigMousePress(event));
  };

  /** Implements mouse-move event */
  virtual void mouseMoveEvent (QMouseEvent *event) {
    emit(sigMouseMove(event));
  };

  /** Implements drag-enter event */
  void dragEnterEvent(QDragEnterEvent *qEvent) {
    emit(sigDragEnter(qEvent));
  };

  /** Implements drag-leave event */
  void dragLeaveEvent(QDragLeaveEvent *qEvent) {
    emit(sigDragLeave(qEvent));
  };

  /** Implements drop event */
  void dropEvent(QDropEvent *qEvent) {
    emit(sigDrop(qEvent));
  };
};

#endif // __QGLSIGNALWIDGET_H_
