
import test_prime

from Server.Client.Core import test_helper


def val(tester):
    repo = test_helper.GetRepo(tester)
    try:

        #Make sure everything was made
        for path in [BASE_CONTAINER,
                     BASE_CONTAINER + '/cont',
                     BASE_CONTAINER + '/cont/sub',
                     BASE_CONTAINER + '/test1.html',
                     BASE_CONTAINER + '/test2.html',
                     BASE_CONTAINER + '/test3.html',
                     BASE_CONTAINER + '/perm',
                     BASE_CONTAINER + '/perm/test-group',
                     BASE_CONTAINER + '/perm/test-user',
                     BASE_CONTAINER + '/perm/test-user2',
                     BASE_CONTAINER + '/test1.xml',
                     BASE_CONTAINER + '/test1.xpathdd',
                     BASE_CONTAINER + '/test1.alias',
                     BASE_CONTAINER + '/test1.aliasref',
                     BASE_CONTAINER + '/test-include.xslt',
                     BASE_CONTAINER + '/test-import.xslt',
                     BASE_CONTAINER + '/test1.xslt',
                     BASE_CONTAINER + '/test2.alias',
                     ]:
                     
            if not repo.hasResource(path):
                tester.error(path + " does not exist")
        return 1
        
    finally:
        repo.txRollback()

import os

BASE_CONTAINER = '/install'

from Ft.Lib.CommandLine import CommandLineTestUtil

import Server

def Init(repo):
    if repo.hasResource(BASE_CONTAINER):
        repo.deleteResource(BASE_CONTAINER)
    repo.createContainer(BASE_CONTAINER)

def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','install'])

    setupFile = os.path.join(os.path.dirname(Server.__file__),'Common','Install','complex.xml')

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    cfg = baseConfig.copy()
    cfg['base'] = BASE_CONTAINER
    tr1 = CommandLineTestUtil.TestRun('Install',
                                      cfg,
                                      [setupFile],
                                      validationFunc = val,
                                      skipOutputTest=True)

    t = CommandLineTestUtil.Test('4ss install',[tr1])

    return t.test(tester)
