
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Relationship
from Ft.Ods.MetaData import Cardinality
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_property
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        test_property.Test(tester,db,Relationship.Relationship)


        tester.startGroup("Relationship Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,Relationship.Relationship,'traversal',Relationship.Relationship)

        tester.startTest("get_cardinality()")
        tx = db.new()
        tx.begin()

        i = Relationship.Relationship(db,None)
        i.form_traversal(Relationship.Relationship(db,None))
        tester.compare(Cardinality.Cardinality. c1_1,i.get_cardinality())
        tester.testDone()

        tester.groupDone()
    finally:
        db.close()



