/* primax_scan -- linux driver for Primax scanners

   Authors:
   Marco Foglia <Marco.Foglia@switzerland.org>
   Thomas Schano <schano@t-online.de>
   Christian Ordig <chr.ordig@gmx.net>

   Copyright (C) 1999 Marco Foglia, Thomas Schano, Christian Ordig

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/


#include <stdlib.h>
#include <stdio.h>
#include <math.h>
                        
#include "primax_scan.h"
#include "tables.h"
#include "LM9811.h"



int RESOLUTION = 300; //dpi

/*-------------------------------------------------------------*/
/* 
 * calculates the color table
 *
 * It's a matrix that transforms 10-Bit ADC-Values in 8-Bit Values
 * send to the computer. With the right values in that table and 2 
 * scans it should be possible to get 30 Bit of color-information
 * to the computer!
 *
 */
void calc_color_table (scan_image *image)
{
    int i, num;
    double midin, val, m, b;
    int maxin = 1023;
    int maxout = 255;
    
    midin = (int)(1024 / 2.0);
//    printf("\n new dataset\n");
    for (num = 0; num < 3; num++) {
	m = 1.0 + image->color[num].contrast / 100.0;
	b = (1.0 + image->color[num].brightness / 100.0) * midin;

//      printf("\nline %d \n",num);
        
	for (i=0; i <= maxin; i++)
        {
	    val = ((double)i) - midin;
	    val = val * m + b;
	    if (val < 0){ 
		val = 0; 
	    }
	    else if (val > maxin){ 
		val = maxin; 
	    }
	    image->color_table[num][i] =
		0.5 + maxout * pow(val / maxin, (1.0 /
                                                 image->color[num].gamma));
//         printf("%2X ",  image->color_table[num][i] );
            
	}

//printdata( &(image->color_table[0][0]), 3, maxin);
        DBG(DBG_HIGH, "calc_colortable:  c: %1.1f  b: %1.1f  c: %1.1f\n",
	    image->color[num].contrast, 
	    image->color[num].brightness, 
	    image->color[num].gamma);
    }
}

/*-------------------------------------------------------------*/
/* 
 * calculates the horizontal resolution of scan area
 * 
 * position from left side  [in] 
 * width                    [pixel] 
 * resolution               [dpi]                                            
 */

void calc_x_table(scan_image *image)
 { int i, xpixcount, xpixcounti;
   double dres, xstart, xend;
    
   if (image->resolution > X_RESOLUTION)
	image->resolution = X_RESOLUTION;
   dres = (double) image->resolution / X_RESOLUTION;

   xstart = image->from_left * 300 ;
   xend   = image->width / dres + image->from_left * 300 + 1;
   
   
   xpixcount =  0;
   xpixcounti = 0;
   for (i=0; i < XRES ; i++)
      image->x_table[i] = 0x00;

   for (i=1; i <= XRES; i++){
       if (dres * i > xpixcounti ){
           if (  (i > xstart) && (i <= xend)  ){
               image->x_table[i-1] = 0x1;
               xpixcount++;
           };
           xpixcounti++;
       };
   };
   image->width =  xpixcount;

 }
/*    -------------------------------------------------------------*/ 
/*      */
/*   * calculates the vertical resolution array */
/*   *  */
/*   * format not yet fully understood */
/*   *  */
/*   * only works for RGB scans  */
/*   * problem at end of dbb not solved */


void calc_y_table(scan_image *image)
{
    int i, ypixcount, ypixcounti;
    double dres, ystart, yend;
    
    if (image->resolution > Y_RESOLUTION)
        image->resolution = Y_RESOLUTION;

    dres = (double) image->resolution / Y_RESOLUTION;

    ystart = image->from_top * 300 ;
    yend   = image->height / dres + image->from_top * 300 + 1;

    ypixcount = -1;
    ypixcounti = 0;

    for (i=0; i < YRES + BLUE_OFFSET; i++)
    {
        image->y_table[i] = 0x00;
        image->y_table_int[i] = 0x00;
    }

    for (i=1; i <= YRES; i++)
    {
        if (dres * i > ypixcounti )
        {
            if (  (i > ystart) && (i <= yend)  )
            {
                if ( image->colormode & 0x1 )
                {
                    image->y_table[i-1 + RED_OFFSET] = 0xf;
//                    image->y_table[i-1 + RED_OFFSET] = 0x1;
                    image->y_table_int[i-1 + RED_OFFSET] =
                        image->y_table_int[i-1 + RED_OFFSET] | 0x1;
                }
                if ( image->colormode & 0x2 )
                {
                   image->y_table[i-1 + GREEN_OFFSET] = 0xf;
//                   image->y_table[i-1 + GREEN_OFFSET] = 0x2;
                   image->y_table_int[i-1 + GREEN_OFFSET] =
                       image->y_table_int[i-1 + GREEN_OFFSET] | 0x2;
                }
                if ( image->colormode & 0x4 )
                {
                    image->y_table[i-1 + BLUE_OFFSET] = 0xf;
//                    image->y_table[i-1 + BLUE_OFFSET] = 0x4;
                    image->y_table_int[i-1 + BLUE_OFFSET] =
                        image->y_table_int[i-1 + BLUE_OFFSET] | 0x4;
                }

                ypixcount++;
            };
            ypixcounti++;
        };
    };
    image->height =  ypixcount;
}































