/* +------------------------------------------------------------------------+
   |                                                                        |
   |                          Entiers de longueur arbitraire                |
   |                                                                        |
   |                             Interface C <-> Ocaml                      |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* M. Quercia, 23/08/2001 */

#ifndef __ml_long_int__
#define __ml_long_int__

#include "long_int.h"

#ifdef use_slong
#define W_of_C(l) (l)                 /* conversion chiffres -> mots      */
#define C_of_W(l) (l)                 /* conversion mots -> chiffres      */
#define xx(nom) sx_##nom              /* prfixe des fonctions publiques  */

#else
#ifdef use_dlong
#define W_of_C(l) (l)                 /* conversion chiffres -> mots      */
#define C_of_W(l) (l)                 /* conversion mots -> chiffres      */
#define xx(nom) dx_##nom              /* prfixe des fonctions publiques  */

#else
#define W_of_C(l) (((l)+1)/2)         /* conversion chiffres -> mots      */
#define C_of_W(l) (2*(l))             /* conversion mots -> chiffres      */
#define xx(nom) cx_##nom              /* prfixe des fonctions publiques  */
#endif
#endif


#endif

