#! /bin/sh
cat <<EOF
program simple;

	(* +--------------------------------------------------------+
	   |  Dmonstration de la bibliothque Numerix avec Pascal  |
	   +--------------------------------------------------------+ *)

(* calcul de (sqrt(3) + sqrt(2))/(sqrt(3)-sqrt(2)) avec n dcimales *)
(* M. Quercia, le 17/08/2001 *)

uses $MODULENAME;

procedure calcul(var res : xint; n : longint);
var dix_n, dix_2n, sqrt_2, sqrt_3, x, y : xint;
begin
   dix_n  := xnew;
   dix_2n := xnew;
   sqrt_2 := xnew;
   sqrt_3 := xnew;
   x      := xnew;
   y      := xnew;

   copy_int(dix_n,5);
   pow     (dix_n,  dix_n,  n);       (* dix_n <- 5^n ...      *)
   shiftl  (dix_n,  dix_n,  n);       (*        ... * 2^n      *)
   sqr     (dix_2n, dix_n);           (* dix_2n <- 10^(2n)     *)
   mul_1   (sqrt_2, dix_2n, 200);     (* sqrt_2 <- ...         *)
   sqrt    (sqrt_2, sqrt_2);          (* .. sqrt(2*10^(2n+2))  *)
   mul_1   (sqrt_3, dix_2n, 300);     (* sqrt_3 <- ...         *)
   sqrt    (sqrt_3, sqrt_3);          (* .. sqrt(3*10^(2n+2))  *)
   add     (x,      sqrt_3, sqrt_2);  (* x <- sqrt_3 + sqrt_2  *)
   sub     (y,      sqrt_3, sqrt_2);  (* y <- sqrt_3 - sqrt_2  *)
   mul     (x,      dix_n,  x);       (* res <- trunc(10^n*x...*)
   quo     (res,    x,      y);       (*               ... /y) *)
   
   xfree(dix_n);
   xfree(dix_2n);
   xfree(sqrt_2);
   xfree(sqrt_3);
   xfree(x);
   xfree(y);

end;


(* programme principal *)
var n,i : longint;
    c   : word;
    x   : xint;
begin

   n := 30;
   x := xnew;
   i := 1;
   while i <= paramcount do begin
      if  paramstr(i) = '-test' then n := 30
      else if (paramstr(i) = '-n') and (i < paramcount) then begin
	 i := i+1;
	 val(paramstr(i),n,c);
      end
      else failwith('syntaxe : simple [-test] [-n <n>]');
      i := i+1;
   end;

   calcul(x,n);
   writeln(string_of(x));

   xfree(x);
   
end.
EOF
