#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2

if(description)
{
  script_id(13751);
  script_version ("$Revision: 1.3 $");
 
  script_name(english:"DirectConnect hub detection");
 
  desc["english"] = "
DirectConnect hub is running on this port. This peer to peer 
software is used to share files, and allow many clients to
connect through.

Risk factor : Medium";

  script_description(english:desc["english"]);
 
  summary["english"] = "DirectConnect hub detection";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  family["english"] = "Peer-To-Peer File Sharing";
  script_family(english:family["english"]);
  script_dependencie("find_service2.nasl");
  script_require_ports(411);

  exit(0);
}

include("misc_func.inc");

port=411;
if(get_port_state(port))
{
 	 soc = open_sock_tcp(port);
	 if(soc)
	 {
		r=recv_line(socket:soc, length:1024);
		if ( ! r ) exit(0);
		if (ereg(pattern:"^\$Lock .+ Pk=.+",string:r))
		{
			str="$quit|";
			send(socket:soc,data:str);
			security_warning(port);
		}
		close(soc);
	 }
}
