//
//  MTabView.h
//
//  Created by Alfredo Kojima on 2/16/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>


typedef enum {
  ISBack,
  ISFront,
  ISHover,
  ISPushed
} MTabViewItemState;


@interface MTabViewItem : NSObject {
  NSString *_identifier;

  MTabViewItemState _state;
  MTabViewItemState _closeState;
  
  NSImage *_icon;
  NSView *_view;
  NSString *_label;
  
  id _representedObject;
}

- (id)initWithIdentifier:(NSString*)identifier;

- (MTabViewItemState)tabState;
- (void)setTabState:(MTabViewItemState)state;

- (void)setIcon:(NSImage*)icon;
- (NSImage*)icon;

- (NSString*)label;
- (void)setLabel:(NSString*)label;

- (NSView*)view;
- (void)setView:(NSView*)view;

- (void)setRepresentedObject:(id)object;
- (id)representedObject;

@end


@interface MTabView : NSView {
  IBOutlet id delegate;

  NSMutableArray *_pages;
  NSMutableDictionary *_tabAttrs;

  BOOL _tabsOnBottom;
  BOOL _brushedMetal;
  
  NSTrackingRectTag *_trackingRects;
  
  NSImage *_closeImage[3];

  NSColor *_backColor[3];
  NSColor *_lborderColor;
  NSColor *_borderColor;

  float _tabY;
  float _tabWidth;
  int _visibleTabCount;

  int _currentPage;
}

- (void)setTabsOnBottom:(BOOL)flag;

- (int)addTabViewItem:(MTabViewItem*)item;
- (void)selectPage:(int)page;
- (MTabViewItem*)selectedPage;

- (void)setDelegate:(id)delegate;

@end
