//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: fluidgui.cpp,v 1.1.1.1 2003/10/29 10:06:05 wschweer Exp $
//
//    This is a simple GUI implemented with QT for
//    fluid software synthesizer.
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <unistd.h>
#include <stdlib.h>
#include "fluidgui.h"
#include <qapplication.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtoolbutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qsocketnotifier.h>

/*
      The interface to the software synthesizer is implemented
      as a pipe connected from stdout of this gui process to
      MusE. MusE redirects the received input to the fluid software
      synthesizer midi device.

      In short communication to the synt takes place as
      midi commands written to stdout.

      All special handling of the synth is done via
      sysex midi commands.
*/

//---------------------------------------------------------
//   FLUIDGui
//---------------------------------------------------------

FLUIDGui::FLUIDGui()
   : FLUIDGuiBase(0, "fluidgui", WType_TopLevel | WDestructiveClose)
      {
      QSocketNotifier* s = new QSocketNotifier(0, QSocketNotifier::Read);
      connect(s, SIGNAL(activated(int)), SLOT(readStdin(int)));

      connect(fdialogButton, SIGNAL(clicked()), SLOT(soundFontFileDialog()));
      connect(loadButton, SIGNAL(clicked()), SLOT(loadFont()));
      }

//---------------------------------------------------------
//   readStdin
//---------------------------------------------------------

void FLUIDGui::readStdin(int fd)
      {
      char buffer[128];
      int n = ::read(fd, buffer, 128);
      printf("FLUID GUI: read %d Bytes from STDIN\n", n);
      }

//---------------------------------------------------------
//   loadFont
//    sysex f0 7c 00 01 name f7
//---------------------------------------------------------

void FLUIDGui::loadFont()
      {
      if (!pathEntry->text().isEmpty()) {
            QFileInfo fi(pathEntry->text());
            if (!fi.exists()) {
                  QString s = QString("SoundFont ") + pathEntry->text() + QString(" does not exists");
                  QMessageBox::critical(this, tr("FLUID: open Soundfile"), s);
                  return;
                  }

            fputc(0xf0, stdout);
            fputc(0x7c, stdout);    // MusE soft synthesizer
            fputc(0x00, stdout);    // fluid
            fputc(0x01, stdout);    // load sound font
            const char* path = pathEntry->text().latin1();
            fputs(path, stdout);
            fputc(0xf7, stdout);
            fflush(stdout);
            }
      }

//---------------------------------------------------------
//   soundFontFileDialog
//---------------------------------------------------------

void FLUIDGui::soundFontFileDialog()
      {
      QString s = QFileDialog::getOpenFileName(QString::null, QString("*.[Ss][Ff]2"), this);
      if (!s.isEmpty()) {
            pathEntry->setText(s);
            }
      }

//---------------------------------------------------------
//   closeEvent
//---------------------------------------------------------

void FLUIDGui::closeEvent(QCloseEvent* ce)
      {
      ce->accept();
      exit(0);
      }

//---------------------------------------------------------
//   main
//---------------------------------------------------------

int main(int argc, char* argv[])
      {
      QApplication app(argc, argv, true);
      QWidget* w = new FLUIDGui;
      if (argc > 1)
            w->setCaption(QString(argv[1]));
      w->show();
      app.connect(&app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()));
      qApp->exec();
      }

